<?php

namespace Drop\RmaMirasvit\Helper\Item;

class Html extends \Mirasvit\Rma\Helper\Item\Html
{
    /**
     * {@inheritDoc}
     */
    public function getItemPrice(
        $item,
        $order
    ) {
        $precision = 2;
        $orderItem = $this->getItemManagement()->getOrderItem($item);

        return $order->formatPricePrecision($orderItem->getPrice() - (($orderItem->getDiscountAmount() * 100) / ($orderItem->getTaxPercent() + 100)) + $orderItem->getTaxAmount(), $precision);
    }

    /**
     * @return \Mirasvit\Rma\Api\Service\Item\ItemManagementInterface
     */
    private function getItemManagement()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Mirasvit\Rma\Api\Service\Item\ItemManagementInterface::class);
    }
}
