<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 27/05/20
 * Time: 11.53
 */

namespace Drop\Pvs\Observer\Order\Rma;


class Update implements \Magento\Framework\Event\ObserverInterface
{
    private $orderRepository;
    private $publisher;

    public function __construct(
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->orderRepository = $orderRepository;
        $this->publisher = $publisher;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $rma = $observer->getData('rma');
        if ($rma->getOrigData('rma_id')) {
            // reso già esistente
            return;
        }

        // nuovo reso
        $order = $this->orderRepository->get($rma->getOrderId());
        // If order is not valid, return
        if (!is_object($order)) {
            throw new \Exception("[PVS][RMA_UPDATE] Order is not an object");
        }

        // Get order incrementId for publish job
        $orderIncrementId = (string)$order->getIncrementId();
        if (empty($orderIncrementId)) {
            throw new \Exception("[PVS][RMA_UPDATE] Order IncrementId is empty");
        }
        // Get rma incrementId for publish job
        $rmaId = $rma->getId();
        if (empty($rmaId)) {
            throw new \Exception("[PVS][RMA_UPDATE] Rma Id is empty");
        }

        // Publish job to queue
        $this->publisher->publish('sales_rma_created', "Rma id #{$rmaId} from order #{$orderIncrementId} - Send to Pvs ftp", $rmaId);
    }
}