<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 12/05/20
 * Time: 11.19
 */

namespace Drop\Pvs\Observer\Order\Invoice;


class Pay implements \Magento\Framework\Event\ObserverInterface
{
    private $publisher;

    /**
     * Pay constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->publisher = $publisher;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @throws \Exception
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        // Get invoice from observer event
        $invoice = $observer->getEvent()->getInvoice();

        // Get order from invoice
        $order = $invoice->getOrder();

        // If order is not valid, return
        if (!is_object($invoice)) {
            throw new \Exception("[PVS][INVOICE_PAY] Invoice is not an object");
        }

        // Get order incrementId for publish job
        $orderIncrementId = (string)$order->getIncrementId();
        if (empty($orderIncrementId)) {
            throw new \Exception("[PVS][INVOICE_PAY] Order IncrementId is empty");
        }
        // Get invoice incrementId for publish job
        $incrementId = (string)$invoice->getIncrementId();
        if (empty($incrementId)) {
            throw new \Exception("[PVS][INVOICE_PAY] Invoice IncrementId is empty");
        }

        // Publish job to queue
        $this->publisher->publish('drop_pvs_invoice_pay', "invoice #{$incrementId} from order #{$orderIncrementId} - Send pdf to Pvs ftp", $incrementId);
    }
}