<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 27/05/20
 * Time: 12.19
 */

namespace Drop\Pvs\Model\Consumer\Order\Rma;


class CreateConsumer implements \Rcason\Mq\Api\ConsumerInterface
{
    const COD_MCON_DAMAGE = '010';
    const RMA_CONDITION_DAMAGE_ID = 3;
    const RMA_REASON_DEFECTIVE_ID = 8;

    private $helper;
    private $ftp;
    private $rmaRepository;
    private $rmaSearchManagement;
    private $orderRepository;
    private $convertArray;
    private $rma;
    private $rmaItems;

    /**
     * CreateConsumer constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Drop\Pvs\Helper\Ftp $ftp
     * @param \Mirasvit\Rma\Api\Repository\RmaRepositoryInterface $rmaRepository
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagement\SearchInterface $rmaSearchManagement
     * @param \Magento\Sales\Api\OrderRepositoryInterface $orderRepository
     * @param \Magento\Framework\Convert\ConvertArray $convertArray
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Drop\Pvs\Helper\Ftp $ftp,
        \Mirasvit\Rma\Api\Repository\RmaRepositoryInterface $rmaRepository,
        \Mirasvit\Rma\Api\Service\Rma\RmaManagement\SearchInterface $rmaSearchManagement,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Magento\Framework\Convert\ConvertArray $convertArray
    )
    {
        $this->helper = $helper;
        $this->ftp = $ftp;
        $this->rmaRepository = $rmaRepository;
        $this->rmaSearchManagement = $rmaSearchManagement;
        $this->orderRepository = $orderRepository;
        $this->convertArray = $convertArray;
    }

    /**
     * @param $rmaId
     * @throws \Exception
     */
    public function process($rmaId)
    {
        if (!$this->helper->checkIfPvsIsEnabled()) {
            return;
        }

        // If rma increment_id is empty, return
        if (empty($rmaId)) {
            throw new \Exception("[PVS][SAVE_RMA_FTP] Rma Id is empty");
        }

        if (!$this->rma = $this->rmaRepository->get($rmaId)) {
            throw new \Exception("[PVS][SAVE_RMA_FTP] Rma Id is empty");
        }

        if (!$this->rmaItems = $this->rmaSearchManagement->getItems($this->rma)) {
            throw new \Exception("[PVS][SAVE_RMA_FTP] Rma are not any item");
        }

        // creo file XDOCE
        $xmlArray = $this->getXmlArrayRows();
        $simpleXmlContents = $this->convertArray->assocToXml(['riga' => $xmlArray], 'doce');

        if (!$this->ftp->checkIfIsEnabled()) {
            return;
        }

        // caricarlo nell'ftp di pvs
        $path = 'IN/XDOCE_' . date('YmdHi') . '.xml';
        try {
            $this->ftp->saveFileToFtp($path, $simpleXmlContents->asXML());
        } catch (\Exception $e) {
            throw new \Exception("[PVS][SAVE_RMA_FTP] Error to save file {$path} - {$e->getMessage()}");
        }
    }

    /**
     * @return array
     */
    public function getXmlArrayRows()
    {
        $order = $this->orderRepository->get($this->rma->getOrderId());

        $xmlArray = [];
        foreach ($this->rmaItems as $item) {
            $xmlArray = [
                'COD_SOCL'    => $this->helper->getCodSocl(),
                'COD_DICL'    => $this->helper->getCodDicl(),
                'COD_ART'     => $item->getProductSku(),
                'QTA_RIGA'    => $item->getQtyRequested(),
                'COD_UM'      => 'PZ',
                'ORDINE'      => $order->getIncrementId(),
                'COD_CLI_FOR' => $this->helper->getCodDicl(),
                'BOLLA'       => $this->rma->getIncrementId(),
                'DATA_BOLLA'  => $this->rma->getCreatedAt(),
                'COD_MCON'    => $this->getCodMcon($item),
            ];
        }

        return $xmlArray;
    }

    /**
     * @param $item
     * @return string
     */
    public function getCodMcon($item)
    {
        /*
         * da scegliere in base a reason_id e condition_id del reso
         * 001- Merce conforme
         * 002- Merce non conforme
         * 010- Prodotto danneggiato
         * 011- Mancanza etichetta/Pendaglio
         * 012- Prodotto macchiato
         * 013- Confezione danneggiata (per questo punto il ricondizionamento delle scarpe avviene da parte di Pvs con le scatole componibili messe a disposizione da La Sportiva)
         * 015- Prodotto usato
         * 020- Merce conforme, ma diversa dalla confezione
         */
        // condition_id = 3 => danneggiato
        // reason_id = 8 => difettato
        if ($item->getConditionId() == self::RMA_CONDITION_DAMAGE_ID || $item->getReasonId() == self::RMA_REASON_DEFECTIVE_ID) {
            return self::COD_MCON_DAMAGE;
        }

        return '';
    }
}