<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 12/05/20
 * Time: 11.48
 */

namespace Drop\Pvs\Model\Consumer\Order\Invoice;


class PayConsumer implements \Rcason\Mq\Api\ConsumerInterface
{
    private $invoice;
    private $helper;
    private $ftp;
    private $pdf;
    private $templateRepository;

    public function __construct(
        \Magento\Sales\Api\Data\InvoiceInterface $invoice,
        \Drop\Pvs\Helper\Data $helper,
        \Drop\Pvs\Helper\Ftp $ftp,
        \Drop\Pdfgenerator\Helper\Pdf $pdf,
        \Eadesigndev\Pdfgenerator\Model\PdfgeneratorRepository $templateRepository
    )
    {
        $this->invoice = $invoice;
        $this->helper = $helper;
        $this->ftp = $ftp;
        $this->pdf = $pdf;
        $this->templateRepository = $templateRepository;
    }

    /**
     * @param $incrementId
     * @throws \Exception
     */
    public function process($incrementId)
    {
        if (!$this->helper->checkIfPvsIsEnabled()) {
            return;
        }

        // If invoice increment_id is empty, return
        if (empty($incrementId)) {
            throw new \Exception("[PVS][SAVE_DOC_FILE_FTP] Increment Id is empty");
        }

        // Load order by orderId
        try {
            $invoice = $this->invoice->loadByIncrementId((string)$incrementId);
        } catch (\Exception $e) {
            throw new \Exception("[PVS][SAVE_DOC_FILE_FTP] Cannot load invoice by incrementId #{$incrementId}");
        }

        // If order is not valid, return
        if (!is_object($invoice)) {
            throw new \Exception("[PVS][SAVE_DOC_FILE_FTP] Invoice is not an object");
        }

        $order = $invoice->getOrder();

        // creare pdf fattura con nome <n_ordine>.pdf
        $this->pdf->setInvoice($invoice);
        $template = $this->templateRepository->getById($this->helper->GetInvoiceTemplateId());
        $this->pdf->setTemplate($template);
        $invoicePdf = $this->pdf->template2Pdf();


        if (!$this->ftp->checkIfIsEnabled()) {
            return;
        }
        // caricarlo nell'ftp di pvs
        $path = 'IN/' . $order->getIncrementId() . '.pdf';
        try {
            $this->ftp->saveFileToFtp($path, $invoicePdf['filestream']);
        } catch (\Exception $e) {
            throw new \Exception("[PVS][SAVE_DOC_FILE_FTP] Error to save file {$path} - {$e->getMessage()}");
        }
    }
}