<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 25/05/20
 * Time: 14.34
 */

namespace Drop\Pvs\Model\Adyen;

use Magento\Sales\Model\Order;

class CancelOrRefund
{
    const RESPONSE_OK = '[cancelOrRefund-received]';

    private $adyen;

    public function __construct(
        \Drop\Pvs\Helper\Adyen $adyen
    )
    {
        $this->adyen = $adyen;
    }

    /**
     * @param $order
     * @throws \Exception
     */
    public function process($order)
    {
        // Make refund
        try {
            $payment = $order->getPayment();
            $result = json_decode($this->adyen->cancelOrRefund($payment->getAdyenPspReference()));
        } catch (\Exception $e) {
            throw new \Exception("[PVS][ADYEN_CANCELORREFUND] order #{$order->getIncrementId()}: {$e->getMessage()}");
        }

        if (empty($result)) {
            throw new \Exception("[PVS][ADYEN_CANCELORREFUND] order #{$order->getIncrementId()} CancelOrRefund failed, result is empty");
        }

        if ($result->response != self::RESPONSE_OK) {
            throw new \Exception("[PVS][ADYEN_CANCELORREFUND] CancelOrRefund failed for order {$order->getIncrementId()}");
        }

        try {
            $order->setState(Order::STATE_CLOSED);
            $order->addStatusToHistory($order->getStatus(), "Order payment cancel or refund on Adyen. Response {$result->response}");
            $order->save();
        } catch (\Exception $e){
            throw new \Exception("[PVS][ADYEN_CANCELORREFUND] change order [{$order->getIncrementId()}] status/state after CancelOrRefund {$e->getMessage()}");
        }
    }
}