<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 12/05/20
 * Time: 12.23
 */

namespace Drop\Pvs\Helper;

use Magento\Store\Model\ScopeInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    const XML_GENERAL_SENDER_EMAIL = 'trans_email/ident_general/email';
    const XML_GENERAL_SENDER_NAME = 'trans_email/ident_general/name';
    const XML_PATH_PVS_ENABLE = 'pvs/general/enable';
    const XML_PATH_PVS_ENABLE_DEBUG = 'pvs/general/enable_debug';
    const XML_PATH_PVS_CANCELED_ORDER_EMAILS = 'pvs/general/canceled_order_email';
    const XML_PATH_PVS_RMA_EMAILS = 'pvs/general/rma_email';
    const XML_PATH_PVS_INVOICE_TEMPLATE_ID = 'pvs/general/invoice_template_id';
    const XML_PATH_PVS_SEND_CMEMO_EMAIL_TO_CUSTOMER = 'pvs/general/send_cmemo_mail_to_customer';
    const XML_PATH_PVS_DECREASE_QTY = 'pvs/general/decrease_qty';
    const XML_PATH_PVS_COD_SOCL = 'pvs/comunication_files_settings/cod_socl';
    const XML_PATH_PVS_COD_DICL = 'pvs/comunication_files_settings/cod_dicl';

    protected $scopeConfig;
    protected $transportBuilder;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->transportBuilder = $transportBuilder;
    }

    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    /**
     * @return mixed
     */
    public function checkIfPvsIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_ENABLE);
    }

    /**
     * @return mixed
     */
    public function checkIfPvsEmailsIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_ENABLE_DEBUG);
    }

    /**
     * @param null $storeId
     * @return array
     */
    public function getCancelOrderEmails($storeId = null)
    {
        return explode(";", $this->getConfigValue(self::XML_PATH_PVS_CANCELED_ORDER_EMAILS, $storeId));
    }

    /**
     * @return mixed
     */
    public function GetInvoiceTemplateId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_INVOICE_TEMPLATE_ID);
    }

    /**
     * @return mixed
     */
    public function canDecreaseQty()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_DECREASE_QTY);
    }

    /**
     * @return mixed
     */
    public function getCodSocl()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_COD_SOCL);
    }

    /**
     * @return mixed
     */
    public function getCodDicl()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_COD_DICL);
    }

    /**
     * @param null $storeId
     * @return array
     */
    public function getRmaEmails($storeId = null)
    {
        return explode(";", $this->getConfigValue(self::XML_PATH_PVS_RMA_EMAILS, $storeId));
    }

    /**
     * @param null $storeId
     * @return mixed
     */
    public function getSendCreditmemoEmailToCustomer($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_SEND_CMEMO_EMAIL_TO_CUSTOMER, $storeId);
    }

    /**
     * @param $content
     * @param string $delimiter
     * @return array
     */
    public function getArrayFromCsv($content, $delimiter = ';')
    {
        $data = [];

        $contentRows = explode("\n", $content);
        $header = explode($delimiter, array_shift($contentRows));

        foreach ($contentRows as $keyRow => $row) {
            foreach (explode($delimiter, $row) as $key => $value) {
                if (!isset($header[$key])) {
                    continue;
                }

                $data[$keyRow][strtolower($header[$key])] = $value;
            }
        }

        return $data;
    }

    /**
     * @param $content
     * @param string $delimiter
     * @return array
     */
    public function getFormattedArrayByXordcStockFileContent($content, $delimiter = ';')
    {
        $data = $this->getArrayFromCsv($content, $delimiter);

        $formattedData = [];
        foreach ($data as $row) {
            // se il campo cod_socl è vuoto passo direttamente al successivo
            if (trim($row['cod_socl']) == '') {
                continue;
            }
            $formattedData[$row['cod_ordc']]['items'][$row['cod_art']] = $row;
            $formattedData[$row['cod_ordc']]['skus'][] = $row['cod_art'];
        }

        return $formattedData;
    }

    /**
     * @param $content
     * @param string $delimiter
     * @return array
     */
    public function getFormattedArrayByXdoceTesFileContentRmaFilter($content, $delimiter = ';')
    {
        $data = $this->getArrayFromCsv($content, $delimiter);

        $formattedData = [];
        foreach ($data as $row) {
            // se il campo cod_socl è vuoto passo direttamente al successivo
            if (trim($row['cod_socl']) == '') {
                continue;
            }
            // prendo solo i resi
            if ($row['cod_cmov'] != 'RESO') {
                continue;
            }
            $formattedData[$row['ordine']]['items'][$row['cod_art']] = $row;
            $formattedData[$row['ordine']]['skus'][] = $row['cod_art'];
        }

        return $formattedData;
    }

    /**
     * @param $templateId
     * @param $templateVars
     * @param $toEmails
     * @param int $areaStoreId
     * @throws \Exception
     */
    public function sendMail($templateId, $templateVars, $toEmails, $areaStoreId = 0)
    {
        $transport = $this->transportBuilder
            ->setTemplateIdentifier($templateId)
            ->setTemplateOptions(['area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => $areaStoreId])
            ->setTemplateVars($templateVars)
            ->setFrom([
                'email' => $this->scopeConfig->getValue(self::XML_GENERAL_SENDER_EMAIL),
                'name'  => $this->scopeConfig->getValue(self::XML_GENERAL_SENDER_NAME)
            ])
            ->addTo($toEmails)
            ->getTransport();
        try {
            $transport->sendMessage();
        } catch (\Exception $e) {
            throw new \Exception("[PVS] Is not possible to send email: {$e->getMessage()}");
        }
    }
}