<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 22/05/20
 * Time: 10.27
 */

namespace Drop\Pvs\Helper;

use Magento\Store\Model\ScopeInterface;

class Adyen extends \Magento\Framework\App\Helper\AbstractHelper
{
    const XML_PATH_ADYEN_MERCHANT = 'payment/adyen_group_all_in_one/adyen_required_settings/merchant_account';
    const XML_PATH_ADYEN_DEMO_MODE = 'payment/adyen_group_all_in_one/adyen_required_settings/demo_mode';
    const XML_PATH_ADYEN_LIVE_API_KEY = 'payment/adyen_group_all_in_one/adyen_required_settings/api_key_live';
    const XML_PATH_ADYEN_LIVE_URL_PREFIX = 'payment/adyen_group_all_in_one/adyen_required_settings/live_endpoint_url_prefix';
    const XML_PATH_ADYEN_TEST_API_KEY = 'payment/adyen_group_all_in_one/adyen_required_settings/api_key_test';

    protected $scopeConfig;
    private $client;
    private $merchantAccount;

    /**
     * Adyen constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->setClient();
    }

    /**
     *
     */
    public function setClient()
    {
        $this->client = new \Adyen\Client();
        $this->merchantAccount = $this->getConfigValue(self::XML_PATH_ADYEN_MERCHANT);
        // 0 => production mode
        // 1 => test mode
        if ($this->getConfigValue(self::XML_PATH_ADYEN_DEMO_MODE) == 0) {
            $this->client->setXApiKey($this->getConfigValue(self::XML_PATH_ADYEN_LIVE_API_KEY));
            $this->client->setEnvironment(\Adyen\Environment::LIVE, $this->getConfigValue(self::XML_PATH_ADYEN_LIVE_URL_PREFIX));
        } elseif ($this->getConfigValue(self::XML_PATH_ADYEN_DEMO_MODE) == 1) {
            $this->client->setXApiKey($this->getConfigValue(self::XML_PATH_ADYEN_TEST_API_KEY));
            $this->client->setEnvironment(\Adyen\Environment::TEST);
        }
    }

    /**
     * @param $field
     * @param null $storeId
     * @return mixed
     */
    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    /**
     * @param $value
     * @param $currency
     * @param $originalReference
     * @return string
     * @throws \Adyen\AdyenException
     * @throws \Throwable
     */
    public function capture($value, $currency, $originalReference)
    {
        try {
            $service = new \Adyen\Service\Modification($this->client);
            $params = array(
                "merchantAccount"    => $this->merchantAccount,
                "modificationAmount" => array(
                    "value"    => $value,
                    "currency" => $currency,
                ),
                "originalReference"  => $originalReference
            );
        } catch (\Exception $e) {
            throw new \Exception("Capture failed (originalPspReference {$originalReference}): {$e->getMessage()}");
        }

        return json_encode($service->capture($params));
    }

    /**
     * @param $originalReference
     * @return string
     * @throws \Adyen\AdyenException
     */
    public function cancel($originalReference)
    {
        $service = new \Adyen\Service\Modification($this->client);
        $params = array(
            "merchantAccount"   => $this->merchantAccount,
            "originalReference" => $originalReference
        );
        return json_encode($service->cancel($params));
    }

    /**
     * @param $originalReference
     * @return string
     * @throws \Adyen\AdyenException
     */
    public function cancelOrRefund($originalReference)
    {
        $service = new \Adyen\Service\Modification($this->client);
        $params = array(
            "merchantAccount"   => $this->merchantAccount,
            "originalReference" => $originalReference
        );
        return json_encode($service->cancelOrRefund($params));
    }

    /**
     * @param $value
     * @param $currency
     * @param $originalReference
     * @return string
     * @throws \Adyen\AdyenException
     */
    public function refund($value, $currency, $originalReference)
    {
        $service = new \Adyen\Service\Modification($this->client);
        $params = array(
            "merchantAccount"    => $this->merchantAccount,
            "modificationAmount" => array(
                "value"    => $value,
                "currency" => $currency,
            ),
            "originalReference"  => $originalReference
        );
        return json_encode($service->refund($params));
    }

    /**
     * Get enabled payments methods
     * @param $value
     * @param $currency
     * @return string
     * @throws \Adyen\AdyenException
     */
    public function paymentMethods($value, $currency)
    {
        $service = new \Adyen\Service\Checkout($this->client);
        $params = array(
            "merchantAccount" => $this->merchantAccount,
            "countryCode"     => "IT",
            "amount"          => array(
                "value"    => $value,
                "currency" => $currency,
            ),
            "channel"         => "Web"
        );
        return $service->paymentMethods($params);

    }

    /**
     * Make a test payment sending raw data
     * @param $currency
     * @param $value
     * @return string
     * @throws \Adyen\AdyenException
     */
    public function makePayment($value, $currency)
    {
        $service = new \Adyen\Service\Checkout($this->client);
        $params = array(
            "amount"          => array(
                "value"    => $value,
                "currency" => $currency
            ),
            "reference"       => "1",
            "paymentMethod"   => array(
                "type"        => "scheme",
                "number"      => "4988438843884305",
                "expiryMonth" => "10",
                "expiryYear"  => "2020",
                "cvc"         => "737",
                "holderName"  => "Simone Monterubbiano"
            ),
            "returnUrl"       => "https://your-company.com/checkout/",
            "merchantAccount" => $this->merchantAccount
        );
        return $service->payments($params);
    }
}