<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 28/05/20
 * Time: 16.54
 */

namespace Drop\Pvs\Cron\Rma;


class CheckReturned
{
    const RETURNED_RMA_FILE_NAME = 'rma-in';

    private $helper;
    private $ftp;
    private $publisher;

    /**
     * CheckReturned constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Drop\Pvs\Helper\Ftp $ftp
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Drop\Pvs\Helper\Ftp $ftp,
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->helper = $helper;
        $this->ftp = $ftp;
        $this->publisher = $publisher;
    }

    public function execute()
    {
        if (!$this->helper->checkIfPvsIsEnabled()) {
            return;
        }

        if (!$this->ftp->checkIfIsEnabled()) {
            return;
        }

        // Publish job to queue
        $this->publisher->publish('drop_pvs_check_rma_returned', "Search " . self::RETURNED_RMA_FILE_NAME . " [returned rma] file on Pvs server", self::RETURNED_RMA_FILE_NAME);
    }
}