<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 15/06/20
 * Time: 12.26
 */

namespace Drop\Pvs\Console\Command\Export\Rma;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class Create extends Command
{
    const RMA_ID = 'id';

    private $state;
    private $createConsumer;

    /**
     * Create constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Pvs\Model\Consumer\Order\Rma\CreateConsumer $createConsumer
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        \Drop\Pvs\Model\Consumer\Order\Rma\CreateConsumer $createConsumer
    )
    {
        $this->state = $state;
        $this->createConsumer = $createConsumer;
        parent::__construct();
    }


    protected function configure()
    {
        $options = [
            new InputOption(
                self::RMA_ID,
                null,
                InputOption::VALUE_REQUIRED,
                'Rma Id'
            )
        ];
        $this->setName('drop:pvs:export:rma');
        $this->setDescription('Export New Rma');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $rmaId = $input->getOption(self::RMA_ID);
        $output->writeln('esportazione file per rma #' . $rmaId);
        $this->createConsumer->process($rmaId);
        $output->writeln('esportato');
    }
}