<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 18/05/20
 * Time: 15.28
 */

namespace Drop\Pvs\Console\Command\Export\Invoice;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class Pdf extends Command
{
    const INCREMENT_ID = 'increment_id';

    private $state;
    private $payConsumer;

    /**
     * Pdf constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Pvs\Model\Consumer\Order\Invoice\PayConsumer $payConsumer
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        \Drop\Pvs\Model\Consumer\Order\Invoice\PayConsumer $payConsumer
    )
    {
        $this->state = $state;
        $this->payConsumer = $payConsumer;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::INCREMENT_ID,
                null,
                InputOption::VALUE_REQUIRED,
                'Invoice Increment Id'
            )
        ];
        $this->setName('drop:pvs:export:invoice:pdf');
        $this->setDescription('Export Invoice Pdf');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $incrementId = $input->getOption(self::INCREMENT_ID);
        $output->writeln('esportazione file per invoice #' . $incrementId);
        $this->payConsumer->process($incrementId);
        $output->writeln('esportati');
    }
}