<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 19/06/20
 * Time: 10.39
 */

namespace Drop\Pvs\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class CreateQueue extends Command
{
    const JOB_TYPE = 'job_type';
    const JOB_VALUE = 'job_value';

    private $state;
    private $publisher;

    public function __construct(
        \Magento\Framework\App\State $state,
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->state = $state;
        $this->publisher = $publisher;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::JOB_TYPE,
                null,
                InputOption::VALUE_REQUIRED,
                'job type (es. sales_rma_created)'
            ),
            new InputOption(
                self::JOB_VALUE,
                null,
                InputOption::VALUE_REQUIRED,
                'job value'
            )
        ];
        $this->setName('drop:pvs:manual:create:queue');
        $this->setDescription('Manual create Queue Job');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $jobType = $input->getOption(self::JOB_TYPE);
        $jobValue = $input->getOption(self::JOB_VALUE);
        $output->writeln('inizio ');
        $this->publisher->publish($jobType, "create job test $jobType", $jobValue);
        $output->writeln('fine importazione');
    }
}