<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 12/05/20
 * Time: 11.19
 */

namespace Drop\Pvs\Observer\Order\Invoice;


class Pay implements \Magento\Framework\Event\ObserverInterface
{
    private $helper;
    private $collectionFactory;
    private $publisher;

    /**
     * Pay constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Rcason\MqMysql\Model\ResourceModel\Queue\Message\CollectionFactory $collectionFactory
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Rcason\MqMysql\Model\ResourceModel\Queue\Message\CollectionFactory $collectionFactory,
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->helper = $helper;
        $this->collectionFactory = $collectionFactory;
        $this->publisher = $publisher;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @throws \Exception
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if (!$this->helper->checkIfPvsIsEnabled()) {
            return;
        }

        // Get invoice from observer event
        $invoice = $observer->getEvent()->getInvoice();

        // Get order from invoice
        $order = $invoice->getOrder();

        // If order is not valid, return
        if (!is_object($invoice)) {
            throw new \Exception("[PVS][INVOICE_PAY] Invoice is not an object");
        }

        // Get order incrementId for publish job
        $orderIncrementId = (string)$order->getIncrementId();
        if (empty($orderIncrementId)) {
            throw new \Exception("[PVS][INVOICE_PAY] Order IncrementId is empty");
        }
        // Get invoice incrementId for publish job
        $incrementId = (string)$invoice->getIncrementId();
        if (empty($incrementId)) {
            throw new \Exception("[PVS][INVOICE_PAY] Invoice IncrementId is empty");
        }

        $jobName = "invoice #{$incrementId} from order #{$orderIncrementId} - Send pdf to Pvs ftp";

        $queue = $this->collectionFactory->create()
            ->addFieldToFilter('name', '"' . $jobName . '"')
            ->setOrder('updated_at', 'ASC');

        if (
            $queue->getSize()
            || (!$queue->getSize() && !in_array($order->getStatus(), $this->helper->getAcceptedSendableOrderStatuses()))
        ) {
            return;
        }

        // Publish job to queue
        $this->publisher->publish('drop_pvs_invoice_pay', $jobName, $incrementId);
    }
}