<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 05/08/20
 * Time: 16.48
 */

namespace Drop\Pvs\Model\Template;

class Processor extends \Eadesigndev\Pdfgenerator\Model\Template\Processor
{
    /**
     * @return array|string
     */
    public function processTemplate()
    {
        // Support theme fallback for email templates
        $isDesignApplied = $this->applyDesignConfig();

        $processor = $this->getTemplateFilter()
//            ->setUseSessionInUrl(false)
            ->setPlainTemplateMode($this->isPlain())
            ->setIsChildTemplate($this->isChildTemplate())
            ->setTemplateProcessor([$this, 'getTemplateContent']);

        $processor->setVariables($this->getVariables());
        $this->setUseAbsoluteLinks(true);
        $html = $this->html($processor);

        if ($isDesignApplied) {
            $this->cancelDesignConfig();
        }

        return $html;
    }

    /**
     * @param $processor
     * @param $area
     * @return mixed
     */
    private function processArea($processor, $area)
    {
        $templates = $this->getTemplate()->getData('store_id');
        $storeId = $templates[0];

        $textProcessor = $processor
            ->setStoreId($storeId)
            ->setDesignParams([0])
            ->filter(__($area));

        return $textProcessor;
    }

    /**
     * @param $processor
     * @return array
     */
    private function html($processor)
    {
        $html = [
            'body' => $this->processArea($processor, $this->getTemplateBody()),
            'header' => $this->processArea($processor, $this->getTemplateHeader()),
            'footer' => $this->processArea($processor, $this->getTemplateFooter()),
            'filename' => $this->processArea($processor, $this->getTemplateFileName()),
        ];

        return $html;
    }
}