<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 25/09/20
 * Time: 10.03
 */

namespace Drop\Pvs\Model\Consumer\Stock;

use Magento\ConfigurableProduct\Model\Product\Type\Configurable as ConfigurableProduct;
use Magento\Catalog\Model\Product\Attribute\Source\Status;

class ConfigurableReset implements \Rcason\Mq\Api\ConsumerInterface
{
    /**
     * @var \Drop\Pvs\Helper\Data
     */
    protected $helper;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $productCollectionFactory;

    /**
     * @var \Magento\CatalogInventory\Helper\Stock
     */
    protected $stockFilter;

    /**
     * @var \Magento\CatalogInventory\Api\StockRegistryInterface
     */
    protected $stockRegistry;

    /**
     * ConfigurableReset constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
     * @param \Magento\CatalogInventory\Helper\Stock $stock
     * @param \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\CatalogInventory\Helper\Stock $stock,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry
    )
    {
        $this->helper = $helper;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->stockFilter = $stock;
        $this->stockRegistry = $stockRegistry;
    }

    /**
     * @param mixed $data
     * @throws \Exception
     */
    public function process($data)
    {
        // prendo tutti i configurabili con stato outofstock, abilitati e prezzo>0
        $collection = $this->productCollectionFactory->create()
            ->addAttributeToSelect('*')
            ->joinField('qty',
                'cataloginventory_stock_item',
                'qty',
                'product_id=entity_id',
                '{{table}}.stock_id=1',
                'left'
            )->joinTable('cataloginventory_stock_item', 'product_id=entity_id', ['stock_status' => 'is_in_stock'])
            ->addAttributeToSelect('stock_status')
            ->addFieldToFilter('stock_status', ['eq' => 0])
            ->addFieldToFilter('type_id', ['eq' => ConfigurableProduct::TYPE_CODE])
            ->addAttributeToFilter('status', ['eq' => Status::STATUS_ENABLED]);

        foreach ($collection as $product) {
            echo "<br/>entro".$product->getSku();
            $children = $product->getTypeInstance()->getUsedProducts($product);
            if (!$this->haveAvailableChilds($children)) {
                continue;
            }

            $this->updateInStockStatus($product);
        }
    }

    /**
     * @param $childs
     * @return bool
     */
    protected function haveAvailableChilds($childs)
    {
        foreach ($childs as $child) {
            $productStock = $this->stockRegistry->getStockItem($child->getId());

            if ($child->getStatus() == Status::STATUS_ENABLED && $child->getPrice() > 1 && $productStock->getQty() > 0) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param $product
     * @throws \Exception
     */
    public function updateInStockStatus($product)
    {
        try {
            $stockItem = $this->stockRegistry->getStockItemBySku($product->getSku());
            $stockItem->setIsInStock(1);
            $this->stockRegistry->updateStockItemBySku($product->getSku(), $stockItem);
        } catch (\Exception $e) {
            throw new \Exception("Error while updating stock product - {$e->getMessage()}");
        }
    }
}