<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 28/05/20
 * Time: 16.57
 */

namespace Drop\Pvs\Model\Consumer\Order\Rma;


class CheckReturnedConsumer
{
    const DEFAULT_PVS_DIR = '/OUT/';
    const DEFAULT_PVS_PROCESSED_DIR = 'processed/';
    const RMA_RETURN_STATUS = 'returned_in_warehouse';

    private $helper;
    private $ftp;
    private $order;
    private $rmaManagement;
    private $rmaRepository;
    private $statusRepository;

    /**
     * CheckReturnedConsumer constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Drop\Pvs\Helper\Ftp $ftp
     * @param \Magento\Sales\Api\Data\OrderInterface $order
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement
     * @param \Mirasvit\Rma\Api\Repository\RmaRepositoryInterface $rmaRepository
     * @param \Mirasvit\Rma\Api\Repository\StatusRepositoryInterface $statusRepository
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Drop\Pvs\Helper\Ftp $ftp,
        \Magento\Sales\Api\Data\OrderInterface $order,
        \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement,
        \Mirasvit\Rma\Api\Repository\RmaRepositoryInterface $rmaRepository,
        \Mirasvit\Rma\Api\Repository\StatusRepositoryInterface $statusRepository
    )
    {
        $this->helper = $helper;
        $this->ftp = $ftp;
        $this->order = $order;
        $this->rmaManagement = $rmaManagement;
        $this->rmaRepository = $rmaRepository;
        $this->statusRepository = $statusRepository;
    }

    /**
     * @param $filename
     * @throws \Exception
     */
    public function process($filename)
    {
        $filePaths = $this->ftp->getFilesList(self::DEFAULT_PVS_DIR, $filename);
        foreach ($filePaths as $filePath) {
            $fileContent = $this->ftp->readFileFromFtp($filePath);
            $receivedRmas = $this->helper->getArrayFromCsv($fileContent);
            foreach ($receivedRmas as $receivedRma) {
                $this->manageRow($receivedRma);
            }

            // move to processed
            $filePathExplode = explode('/', $filePath);
            $this->ftp->moveFtpFile($filePath, self::DEFAULT_PVS_DIR . self::DEFAULT_PVS_PROCESSED_DIR . end($filePathExplode));
        }
    }

    /**
     * @param $receivedRma
     * @throws \Exception
     */
    public function manageRow($receivedRma)
    {
        // se il campo order_number è vuoto passo direttamente al successivo
        $orderNumber = str_replace('-0', '', $receivedRma['order_number']);
        if (trim($orderNumber) == '') {
            return;
        }

        // controllo se esiste l'ordine
        if (!$order = $this->order->loadByIncrementId($orderNumber)) {
            throw new \Exception("[PVS][CHECK_RETURNED_RMA] Order #{$orderNumber} not found");
        }


        // controllo se esiste il reso
        if (!$rmas = $this->rmaManagement->getRmasByOrder($order)) {
            // inserisco commento sull'ordine
            $order->addStatusToHistory('complete', 'we have received a return for this order without a rma request');
            try {
                $order->save();
            } catch (\Exception $e) {
                throw new \Exception("[PVS][CHECK_RETURNED_RMA] #{$order->getIncrementId()} save error - {$e->getMessage()}");
            }
            return;
        }

        // aggiorno lo stato del reso in returned_in_warehouse
        foreach ($rmas as $rma) {
            if ($rma->getIncrementId() != $receivedRma['rma_number']) {
                continue;
            }
            try {
                $status = $this->statusRepository->getByCode(self::RMA_RETURN_STATUS);
                $rma->setStatusId($status->getId());

                $this->rmaRepository->save($rma);
            } catch (\Exception $e) {
                throw new \Exception("[PVS][CHECK_RETURNED_RMA] rma #{$rma->getIncrementId()} save status: {$e->getMessage()}");
            }

        }
    }
}