<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 20/07/20
 * Time: 11.22
 */

namespace Drop\Pvs\Model\Config\Source;

class Attributes implements \Magento\Framework\Option\ArrayInterface
{
    protected $_options;
    protected $eavAttribute;
    protected $entity;

    public function __construct(
        \Magento\Eav\Model\Attribute $eavAttribute,
        \Magento\Eav\Model\Entity $entity
    )
    {
        $this->eavAttribute = $eavAttribute;
        $this->entity = $entity;
    }

    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options[] = ['value' => '', 'label' => ''];
            foreach ($this->getProductAttributes() as $productAttribute) {
                $this->_options[] = [
                    'value' => $productAttribute->getAttributeCode(),
                    'label' => $productAttribute->getFrontendLabel(),
                ];
            }
        }

        return $this->_options;
    }

    public function getProductAttributes()
    {
        $attributeCollection = $this->eavAttribute->getCollection();
        $attributeCollection->addFieldToFilter('entity_type_id', $this->entity->setType('catalog_product')->getTypeId());

        return $attributeCollection;
    }
}