<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 25/05/20
 * Time: 12.49
 */

namespace Drop\Pvs\Model\Adyen;

use Magento\Sales\Model\Order;

class Refund
{
    const RESPONSE_OK = '[refund-received]';

    /**
     * @var \Drop\Pvs\Helper\Adyen
     */
    private $adyen;

    /**
     * Refund constructor.
     * @param \Drop\Pvs\Helper\Adyen $adyen
     */
    public function __construct(
        \Drop\Pvs\Helper\Adyen $adyen
    )
    {
        $this->adyen = $adyen;
    }

    /**
     * @param $order
     * @param $value
     * @throws \Exception
     */
    public function process($order, $value)
    {
        // Make refund
        try {
            $payment = $order->getPayment();
            $result = json_decode(
                $this->adyen->refund(
                    $value,
                    $order->getOrderCurrencyCode(),
                    $payment->getAdyenPspReference()
                )
            );
        } catch (\Exception $e) {
            throw new \Exception("[PVS][ADYEN_REFUND] order #{$order->getIncrementId()}: {$e->getMessage()}");
        }

        if (empty($result)) {
            throw new \Exception("[PVS][ADYEN_REFUND] order #{$order->getIncrementId()} Refund failed, result is empty");
        }

        if ($result->response != self::RESPONSE_OK) {
            throw new \Exception("[PVS][ADYEN_REFUND] Refund failed for order {$order->getIncrementId()}");
        }

        try {
            $order->setState(Order::STATE_CLOSED);
            $order->addStatusToHistory($order->getStatus(), "Order payment refunded on Adyen. Response {$result->response}");
            $order->save();
        } catch (\Exception $e){
            throw new \Exception("[PVS][ADYEN_REFUND] change order [{$order->getIncrementId()}] status after refund {$e->getMessage()}");
        }
    }
}