<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 18/05/20
 * Time: 14.07
 */

namespace Drop\Pvs\Helper;

use League\Flysystem\Filesystem;
use League\Flysystem\Adapter\Ftp as Adapter;
//use League\Flysystem\FTP\FtpAdapter as Adapter; V2
use Magento\Store\Model\ScopeInterface;

class Ftp extends \Magento\Framework\App\Helper\AbstractHelper
{
    const XML_PATH_PVS_FTP_ENABLE = 'pvs/ftp/enable';
    const XML_PATH_PVS_FT_HOST = 'pvs/ftp/host';
    const XML_PATH_PVS_FT_PORT = 'pvs/ftp/port';
    const XML_PATH_PVS_FT_USER = 'pvs/ftp/user';
    const XML_PATH_PVS_FT_PWD = 'pvs/ftp/password';
    const XML_PATH_PVS_FT_ROOT = 'pvs/ftp/root_path';

    /**
     * @param $field
     * @param null $storeId
     * @return mixed
     */
    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    /**
     * @return mixed
     */
    public function checkIfIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_FTP_ENABLE);
    }

    /**
     * @return Filesystem
     * @throws \Exception
     */
    public function getConnection()
    {
        try {
            return new Filesystem(new Adapter([
                'host'     => $this->getConfigValue(self::XML_PATH_PVS_FT_HOST),
                'username' => $this->getConfigValue(self::XML_PATH_PVS_FT_USER),
                'password' => $this->getConfigValue(self::XML_PATH_PVS_FT_PWD),
                /** optional config settings */
                'port'     => $this->getConfigValue(self::XML_PATH_PVS_FT_PORT) ?? 21,
                'root'     => $this->getConfigValue(self::XML_PATH_PVS_FT_ROOT),
//                'passive'              => true,
//                'ssl'                  => true,
//                'timeout'              => 30,
//                'ignorePassiveAddress' => false,
            ]));

//            //V2
//            return new Filesystem(new Adapter(
//                \League\Flysystem\FTP\FtpConnectionOptions::fromArray([
//                    'host'     => $this->getConfigValue(self::XML_PATH_PVS_FT_HOST),
//                    'username' => $this->getConfigValue(self::XML_PATH_PVS_FT_USER),
//                    'password' => $this->getConfigValue(self::XML_PATH_PVS_FT_PWD),
//                    /** optional config settings */
//                    'port'     => $this->getConfigValue(self::XML_PATH_PVS_FT_PORT) ?? 21,
//                    'root'     => $this->getConfigValue(self::XML_PATH_PVS_FT_ROOT),
////                'passive'              => true,
////                'ssl'                  => true,
////                'timeout'              => 30,
////                'ignorePassiveAddress' => false,
//                ]),
//                new \League\Flysystem\FTP\FtpConnectionProvider(),
//                new \League\Flysystem\FTP\NoopCommandConnectivityChecker(),
//                new \League\Flysystem\UnixVisibility\PortableVisibilityConverter()
//            ));
        } catch (\Exception $e) {
            throw new \Exception("errore connessione FTP - {$e->getMessage()}");
        }
    }

    /**
     * @param $path
     * @param $contents
     * @return bool
     * @throws \Exception
     */
    public function saveFileToFtp($path, $contents)
    {
        if (!$this->getConnection()->put($path, $contents)) {
            return false;
        }

        return true;
    }

    /**
     * @param $path
     * @return bool
     * @throws \Exception
     */
    public function readFileFromFtp($path)
    {
        if (!$this->getConnection()->has($path)) {
            return false;
        }

        $contents = $this->getConnection()->read($path);

        return $contents;
    }

    /**
     * @param $from
     * @param $to
     * @return bool
     * @throws \Exception
     */
    public function moveFtpFile($from, $to)
    {
        if ($this->getConnection()->rename($from, $to)) {
            return false;
        }

        return true;
    }

    /**
     * @param $path
     * @param bool $globalName
     * @param bool $recursive
     * @return array
     * @throws \Exception
     */
    public function getFilesList($path, $globalName = false, $recursive = false)
    {
        $list = $this->getConnection()->listContents($path, $recursive);

        $files = [];
        foreach ($list as $file) {
            if ($globalName && strpos($file['filename'], $globalName) === false) {
                continue;
            }

            $files[] = $file['path'];
        }

        return $files;
    }

}
