<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 12/05/20
 * Time: 12.23
 */

namespace Drop\Pvs\Helper;

use Magento\Store\Model\ScopeInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    const XML_GENERAL_SENDER_EMAIL = 'trans_email/ident_general/email';
    const XML_GENERAL_SENDER_NAME = 'trans_email/ident_general/name';
    const XML_PATH_PVS_ENABLE = 'pvs/general/enable';
    const XML_PATH_PVS_ENABLE_DEBUG = 'pvs/general/enable_debug';
    const XML_PATH_PVS_CANCELED_ORDER_EMAILS = 'pvs/general/canceled_order_email';
    const XML_PATH_PVS_RMA_EMAILS = 'pvs/general/rma_email';
    const XML_PATH_PVS_INVOICE_TEMPLATE_ID = 'pvs/general/invoice_template_id';
    const XML_PATH_PVS_PROFORMA_TEMPLATE_ID = 'pvs/general/proforma_template_id';
    const XML_PATH_PVS_PROFORMA_REM_TEMPLATE_ID = 'pvs/general/proforma_rem_template_id';
    const XML_PATH_PVS_DECLARATION_TEMPLATE_ID = 'pvs/general/declaration_template_id';
    const XML_PATH_PVS_DEC_PREF_TEMPLATE_ID = 'pvs/general/dec_pref_template_id';
    const XML_PATH_PVS_GIFT_MESSAGE_TEMPLATE_ID = 'pvs/general/gift_message_template_id';
    const XML_PATH_PVS_NO_TOTAL_INVOICE_TEMPLATE_ID = 'pvs/general/invoice_no_total_template_id';
    const XML_PATH_PVS_NO_TOTAL_PROFORMA_TEMPLATE_ID = 'pvs/general/proforma_no_total_template_id';
    const XML_PATH_PVS_SEND_CMEMO_EMAIL_TO_CUSTOMER = 'pvs/general/send_cmemo_mail_to_customer';
    const XML_PATH_PVS_DECREASE_QTY = 'pvs/general/decrease_qty';
    const XML_PATH_PVS_SPECIAL_ITEMS_ENABLE = 'pvs/general/enable_special_items';
    const XML_PATH_PVS_SPECIAL_ITEMS_ATTRIBUTE = 'pvs/general/special_items_attribute';
    const XML_PATH_PVS_SPECIAL_ITEMS_EMAIL = 'pvs/general/special_items_email';
    const XML_PATH_PVS_ACCEPTED_SENDABLE_ORDER_STATUSES = 'pvs/general/order_statuses';
    const XML_PATH_PVS_COD_SOCL = 'pvs/comunication_files_settings/cod_socl';
    const XML_PATH_PVS_COD_DICL = 'pvs/comunication_files_settings/cod_dicl';
    const XML_PATH_PVS_ENABLE_DAILY_REPORT = 'pvs/report/enable_daily';
    const XML_PATH_PVS_RESET_CONFIGURABLE_STOCK = 'pvs/general/enable_stock_reset_configurable';
    const XML_PATH_PVS_REPORT_ACCEPTED_ORDER_STATUSES = 'pvs/report/order_statuses';
    const XML_PATH_PVS_REPORT_EMAILS = 'pvs/report/email';
    const XML_PATH_PVS_REPORT_RATES_APP_ID = 'pvs/report/rates_app_id';
    const XML_PATH_PVS_REPORT_BEST_SELLERS_LIMIT = 'pvs/report/bestsellers_limit';
    const XML_PATH_PVS_REPORT_ANALYTICS_ENABLED = 'pvs/report/enable_analytics';
    const XML_PATH_PVS_REPORT_ANALYTICS_PAGE_ID = 'pvs/report/analytics_page_id';
    const XML_PATH_PVS_REPORT_ANALYTICS_PROJECT_ID = 'pvs/report/analytics_project_id';
    const XML_PATH_PVS_REPORT_ANALYTICS_PRIVATE_KEY_ID = 'pvs/report/analytics_private_key_id';
    const XML_PATH_PVS_REPORT_ANALYTICS_PRIVATE_KEY = 'pvs/report/analytics_private_key';
    const XML_PATH_PVS_REPORT_ANALYTICS_CLIENT_EMAIL = 'pvs/report/analytics_client_email';
    const XML_PATH_PVS_REPORT_ANALYTICS_CLIENT_ID = 'pvs/report/analytics_client_id';
    const XML_PATH_EU_COUNTRIES = 'general/country/eu_countries';

    protected $scopeConfig;
    protected $transportBuilder;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->transportBuilder = $transportBuilder;
    }

    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    /**
     * @return mixed
     */
    public function checkIfPvsIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_ENABLE);
    }

    /**
     * @return mixed
     */
    public function checkIfPvsEmailsIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_ENABLE_DEBUG);
    }

    /**
     * @param null $storeId
     * @return array
     */
    public function getCancelOrderEmails($storeId = null)
    {
        return explode(";", $this->getConfigValue(self::XML_PATH_PVS_CANCELED_ORDER_EMAILS, $storeId));
    }

    /**
     * @return mixed
     */
    public function GetInvoiceTemplateId($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_INVOICE_TEMPLATE_ID, $storeId);
    }

    /**
     * @return mixed
     */
    public function GetProformaTemplateId($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_PROFORMA_TEMPLATE_ID, $storeId);
    }

    /**
     * @return mixed
     */
    public function GetProformaRemTemplateId($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_PROFORMA_REM_TEMPLATE_ID, $storeId);
    }

    /**
     * @return mixed
     */
    public function GetDecPrefTemplateId($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_DEC_PREF_TEMPLATE_ID, $storeId);
    }

    /**
     * @return mixed
     */
    public function GetDeclarationTemplateId($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_DECLARATION_TEMPLATE_ID, $storeId);
    }

    /**
     * @return mixed
     */
    public function GetGiftMessageTemplateId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_GIFT_MESSAGE_TEMPLATE_ID);
    }

    /**
     * @return mixed
     */
    public function GetNoTotalInvoiceTemplateId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_NO_TOTAL_INVOICE_TEMPLATE_ID);
    }

    /**
     * @return mixed
     */
    public function GetNoTotalProformaTemplateId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_NO_TOTAL_PROFORMA_TEMPLATE_ID);
    }

    /**
     * @return mixed
     */
    public function canDecreaseQty()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_DECREASE_QTY);
    }

    /**
     * @return mixed
     */
    public function checkIfSpecialItemsIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_SPECIAL_ITEMS_ENABLE);
    }

    /**
     * @return mixed
     */
    public function getSpecialItemsAttribute()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_SPECIAL_ITEMS_ATTRIBUTE);
    }

    /**
     * @param null $storeId
     * @return array
     */
    public function getSpecialItemsEmail($storeId = null)
    {
        return explode(";", $this->getConfigValue(self::XML_PATH_PVS_SPECIAL_ITEMS_EMAIL, $storeId));
    }

    /**
     * @return array
     */
    public function getAcceptedSendableOrderStatuses()
    {
        return explode(",", $this->getConfigValue(self::XML_PATH_PVS_ACCEPTED_SENDABLE_ORDER_STATUSES));
    }

    /**
     * @return mixed
     */
    public function getCodSocl()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_COD_SOCL);
    }

    /**
     * @return mixed
     */
    public function getCodDicl()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_COD_DICL);
    }

    /**
     * @param null $storeId
     * @return array
     */
    public function getRmaEmails($storeId = null)
    {
        return explode(";", $this->getConfigValue(self::XML_PATH_PVS_RMA_EMAILS, $storeId));
    }

    /**
     * @param null $storeId
     * @return mixed
     */
    public function getSendCreditmemoEmailToCustomer($storeId = null)
    {
        return $this->getConfigValue(self::XML_PATH_PVS_SEND_CMEMO_EMAIL_TO_CUSTOMER, $storeId);
    }

    /**
     * @return mixed
     */
    public function checkIfDailyReportIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_ENABLE_DAILY_REPORT);
    }

    /**
     * @return mixed
     */
    public function checkIfResetConfigurableStockIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_RESET_CONFIGURABLE_STOCK);
    }

    /**
     * @return array
     */
    public function getAcceptedReportOrderStatuses()
    {
        return explode(",", $this->getConfigValue(self::XML_PATH_PVS_REPORT_ACCEPTED_ORDER_STATUSES));
    }

    /**
     * @return array
     */
    public function getReportEmails()
    {
        return explode(";", $this->getConfigValue(self::XML_PATH_PVS_REPORT_EMAILS));
    }

    /**
     * @return mixed
     */
    public function getRatesAppId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_RATES_APP_ID);
    }

    /**
     * @return mixed
     */
    public function getBestSellersLimit()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_BEST_SELLERS_LIMIT);
    }

    /**
     * @return mixed
     */
    public function getEuCountriesArray()
    {
        return explode(',', $this->getConfigValue(self::XML_PATH_EU_COUNTRIES));
    }

    /**
     * @return mixed
     */
    public function checkIfAnalyticsIsEnabled()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_ENABLED);
    }

    /**
     * @return mixed
     */
    public function getAnalyticsPageId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_PAGE_ID);
    }

    /**
     * @return mixed
     */
    public function getAnalyticsProjectId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_PROJECT_ID);
    }

    /**
     * @return mixed
     */
    public function getAnalyticsPrivateKeyId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_PRIVATE_KEY_ID);
    }

    /**
     * @return mixed
     */
    public function getAnalyticsPrivateKey()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_PRIVATE_KEY);
    }

    /**
     * @return mixed
     */
    public function getAnalyticsClientEmail()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_CLIENT_EMAIL);
    }

    /**
     * @return mixed
     */
    public function getAnalyticsClientId()
    {
        return $this->getConfigValue(self::XML_PATH_PVS_REPORT_ANALYTICS_CLIENT_ID);
    }

    /**
     * @param $content
     * @param string $delimiter
     * @return array
     */
    public function getArrayFromCsv($content, $delimiter = ';')
    {
        $data = [];

        $contentRows = explode("\n", $content);
        $header = explode($delimiter, array_shift($contentRows));

        foreach ($contentRows as $keyRow => $row) {
            if($row == null) {
                continue;
            }

            foreach (explode($delimiter, $row) as $key => $value) {
                if (!isset($header[$key])) {
                    continue;
                }

                $data[$keyRow][strtolower($header[$key])] = $value;
            }
        }

        return $data;
    }

    /**
     * @param $content
     * @param string $delimiter
     * @return array
     */
    public function getFormattedArrayByXordcStockFileContent($content, $delimiter = ';')
    {
        $data = $this->getArrayFromCsv($content, $delimiter);

        $formattedData = [];
        foreach ($data as $row) {
            // se il campo cod_socl è vuoto passo direttamente al successivo
            if (trim($row['cod_socl']) == '') {
                continue;
            }
            $orderNumber = str_replace('-0', '', $row['cod_ordc']);
            $formattedData[$orderNumber]['items'][$row['cod_art']] = $row;
            $formattedData[$orderNumber]['skus'][] = $row['cod_art'];
        }

        return $formattedData;
    }

    /**
     * @param $content
     * @param string $delimiter
     * @return array
     */
    public function getFormattedArrayByXdoceTesFileContentRmaFilter($content, $delimiter = ';')
    {
        $data = $this->getArrayFromCsv($content, $delimiter);

        $formattedData = [];
        foreach ($data as $row) {
            // se il campo cod_socl è vuoto passo direttamente al successivo
            if (trim($row['cod_socl']) == '') {
                continue;
            }
            // prendo solo i resi
            if ($row['cod_cmov'] != 'RESO') {
                continue;
            }
            $orderNumber = str_replace('-0', '', $row['ordine']);
            $formattedData[$orderNumber]['items'][$row['cod_art']] = $row;
            $formattedData[$orderNumber]['skus'][] = $row['cod_art'];
        }

        return $formattedData;
    }

    /**
     * @param $templateId
     * @param $templateVars
     * @param $toEmails
     * @param int $areaStoreId
     * @throws \Exception
     */
    public function sendMail($templateId, $templateVars, $toEmails, $areaStoreId = 0)
    {
        $transport = $this->transportBuilder
            ->setTemplateIdentifier($templateId)
            ->setTemplateOptions(['area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => $areaStoreId])
            ->setTemplateVars($templateVars)
            ->setFrom([
                'email' => $this->scopeConfig->getValue(self::XML_GENERAL_SENDER_EMAIL),
                'name'  => $this->scopeConfig->getValue(self::XML_GENERAL_SENDER_NAME)
            ])
            ->addTo($toEmails)
            ->getTransport();
        try {
            $transport->sendMessage();
        } catch (\Exception $e) {
            throw new \Exception("[PVS] Is not possible to send email: {$e->getMessage()}");
        }
    }

    /**
     * @param $order
     * @return bool
     */
    public function checkIfOrderHasSpecialItems($order)
    {
        if (!$this->checkIfSpecialItemsIsEnabled()) {
            return false;
        }

        foreach ($order->getAllVisibleItems() as $item) {
            if ($item->getProduct()->getData($this->getSpecialItemsAttribute())) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param $order
     * @return bool
     */
    public function checkIsGiftCard($order)
    {
        foreach ($order->getAllVisibleItems() as $visibleItem) {
            if ($visibleItem->getProductType() != 'giftcard') {
                continue;
            }

            return true;
        }

        return false;
    }
}
