<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 25/09/20
 * Time: 9.57
 */

namespace Drop\Pvs\Cron\Stock;

class ResetConfigurable
{
    private $helper;
    private $publisher;
    protected $dateTime;

    /**
     * ResetConfigurable constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTime
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTime
    )
    {
        $this->helper = $helper;
        $this->publisher = $publisher;
        $this->dateTime = $dateTime;
    }

    public function execute()
    {
        if (!$this->helper->checkIfResetConfigurableStockIsEnabled()) {
            return;
        }

        // Publish job to queue
        $this->publisher->publish('drop_pvs_stock_reset_configurable', "Check configurable product is_in_stocl", '');
    }
}