<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 05/06/20
 * Time: 16.15
 */

namespace Drop\Pvs\Cron\Rma;


class ManageReturned
{
    const RETURNED_RMA_FILE_NAME = 'XDOCE_TES';

    private $helper;
    private $ftp;
    private $publisher;

    /**
     * ManageReturned constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Drop\Pvs\Helper\Ftp $ftp
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Drop\Pvs\Helper\Ftp $ftp,
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->helper = $helper;
        $this->ftp = $ftp;
        $this->publisher = $publisher;
    }

    public function execute()
    {
        if (!$this->helper->checkIfPvsIsEnabled()) {
            return;
        }

        if (!$this->ftp->checkIfIsEnabled()) {
            return;
        }

        // Publish job to queue
        $this->publisher->publish('drop_pvs_manage_rma', "Search " . self::RETURNED_RMA_FILE_NAME . " [returned rma detail] file on Pvs server", self::RETURNED_RMA_FILE_NAME);
    }
}