<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 05/06/20
 * Time: 16.15
 */

namespace Drop\Pvs\Cron\Report;


class Daily
{
    private $helper;
    private $publisher;
    protected $dateTime;

    /**
     * Daily constructor.
     * @param \Drop\Pvs\Helper\Data $helper
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTime
     */
    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTime
    )
    {
        $this->helper = $helper;
        $this->publisher = $publisher;
        $this->dateTime = $dateTime;
    }

    public function execute()
    {
        if (!$this->helper->checkIfDailyReportIsEnabled()) {
            return;
        }

        $date = $this->dateTime->date()->sub(new \DateInterval('P1D'))->format('Y-m-d');

        // Publish job to queue
        $this->publisher->publish('drop_pvs_daily_report', "Create daily report {$date}", $date);
    }
}