<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 11/12/20
 * Time: 16.41
 */

namespace Drop\Pvs\Cron\Order;

use Magento\Sales\Model\Order;

class ManageZeroSubtotal
{
    protected $orderCollectionFactory;
    protected $invoiceService;

    public function __construct(
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
        \Magento\Sales\Model\Service\InvoiceService $invoiceService
    )
    {
        $this->orderCollectionFactory = $orderCollectionFactory;
        $this->invoiceService = $invoiceService;
    }

    public function execute()
    {
        $orders = $this->orderCollectionFactory->create()
            ->addAttributeToSelect('*')
            ->join(
                ["sop" => "sales_order_payment"],
                'main_table.entity_id = sop.parent_id',
                ['method']
            )
            ->addFieldToFilter('method', ['eq' => 'free'])
            ->addFieldToFilter('status', ['eq' => 'pending']);

        foreach ($orders as $order) {
            if (!$order->canInvoice()) {
                continue;
            }

            try {
                $invoice = $this->invoiceService->prepareInvoice($order);
                $invoice->register();

                $order->setState(Order::STATE_PROCESSING)->setStatus(Order::STATE_PROCESSING);
                try {
                    $order->save();
                } catch (\Exception $e) {
                    throw new \Exception("[PVS][MANAGE_ZERO_SUBTOTAL] #{$order->getIncrementId()} save status error - {$e->getMessage()}");
                }

                $invoice->save();
            } catch (\Exception $e) {
                throw new \Exception("[PVS][MANAGE_ZERO_SUBTOTAL] #{$order->getIncrementId()} create invoice error - {$e->getMessage()}");
            }
        }
    }
}