<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 19/05/20
 * Time: 11.06
 */

namespace Drop\Pvs\Cron\Order;


class CheckCanceled
{
    const WRONG_ORDERS_FILE_NAME = 'XORDC_STOCK';

    private $helper;
    private $ftp;
    private $publisher;

    public function __construct(
        \Drop\Pvs\Helper\Data $helper,
        \Drop\Pvs\Helper\Ftp $ftp,
        \Rcason\Mq\Api\PublisherInterface $publisher
    )
    {
        $this->helper = $helper;
        $this->ftp = $ftp;
        $this->publisher = $publisher;
    }

    public function execute()
    {
        if (!$this->helper->checkIfPvsIsEnabled()) {
            return;
        }

        if (!$this->ftp->checkIfIsEnabled()) {
            return;
        }

        // Publish job to queue
        $this->publisher->publish('drop_pvs_check_canceled', "Search " . self::WRONG_ORDERS_FILE_NAME . " [canceled orders] file on Pvs server", self::WRONG_ORDERS_FILE_NAME);
    }
}