<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 11/12/20
 * Time: 11.14
 */

namespace Drop\Pvs\Cron;

use Rcason\MqGui\Model\MqFactory;

class CheckQueue
{

    protected $mqFactory;
    protected $orderCollectionFactory;

    /**
     * CheckQueue constructor.
     * @param MqFactory $mqFactory
     * @param \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
     */
    public function __construct(
        MqFactory $mqFactory,
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
    )
    {
        $this->mqFactory = $mqFactory;
        $this->orderCollectionFactory = $orderCollectionFactory;
    }

    public function execute()
    {
        // recupero tutti gli ordini a processing
        $orders = $this->orderCollectionFactory->create()
            ->addAttributeToSelect('*')
            ->addFieldToFilter('status', ['eq' => 'processing']);

        foreach ($orders as $order) {
            // recupero il relativo job
            $job = $this->mqFactory->create()->getCollection()
                ->addFieldToFilter('queue_name', ['eq' => 'drop_pvs_invoice_pay'])
                ->addFieldToFilter('name', ['like' => '%order #' . $order->getIncrementId() . '%'])
                ->getFirstItem();
            if ($job->getStatus() != 1) {
                continue;
            }

            // se arrivo qui significa che il cron è stato eseguito ma l'ordine non è a processing, quindi va rieseguito
            $job->setStatus(0);
            $job->save();
        }
    }
}