<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 15/06/20
 * Time: 12.27
 */

namespace Drop\Pvs\Console\Command\Import\Order;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class CheckCanceled extends Command
{
    const FILENAME = 'filename';

    private $state;
    private $checkCanceledConsumer;

    /**
     * CheckCanceled constructor.
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Pvs\Model\Consumer\Order\CheckCanceledConsumer $checkCanceledConsumer
     */
    public function __construct(
        \Magento\Framework\App\State $state,
        \Drop\Pvs\Model\Consumer\Order\CheckCanceledConsumer $checkCanceledConsumer
    )
    {
        $this->state = $state;
        $this->checkCanceledConsumer = $checkCanceledConsumer;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::FILENAME,
                null,
                InputOption::VALUE_REQUIRED,
                'file name (rma_in)'
            )
        ];
        $this->setName('drop:pvs:import:canceled');
        $this->setDescription('Import Canceled Order');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            // this tosses an error if the areacode is not set.
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('adminhtml');
        }

        $filename = $input->getOption(self::FILENAME);
        $output->writeln('inizio import file ' . $filename);
        $this->checkCanceledConsumer->process($filename);
        $output->writeln('fine importazione');
    }
}