<?php


namespace Drop\Pvs\Cron\Import;


use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Model\Ftp\Downloader;
use Magento\Framework\MessageQueue\PublisherInterface;

class Stock
{

    const TOPIC_NAME = 'pvs.import.stock';

    private $configuration;
    private $publisher;
    private $downloader;
    private $fileImport;

    /**
     * Stock constructor.
     * @param ConfigurationHelper $configuration
     * @param PublisherInterface $publisher
     * @param Downloader $downloader
     * @param FileInterface $fileImport
     */
    public function __construct(
        ConfigurationHelper $configuration,
        PublisherInterface $publisher,
        Downloader $downloader,
        FileInterface $fileImport
    )
    {
        $this->configuration = $configuration;
        $this->publisher = $publisher;
        $this->downloader = $downloader;
        $this->fileImport = $fileImport;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled()) {
            return;
        }
        $files = $this->downloader->list(
            $this->configuration->getStockFilename(),
            $this->configuration->getFtpReadDir()
        );

        $this->publisher->publish(self::TOPIC_NAME, $this->getPublisherData($files));
    }

    /**
     * @param $files
     * @param bool $canDeleteFiles
     * @return FileInterface
     */
    public function getPublisherData($files, bool $canDeleteFiles = true): FileInterface
    {
        $this->fileImport->setFiles($files);
        $this->fileImport->setCanDeleteFiles($canDeleteFiles);

        return $this->fileImport;
    }
}
