<?php

namespace Drop\Pvs\Model\Config\Source;

use Magento\Eav\Model\Attribute;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Rma\Api\RmaAttributesManagementInterface;

class ReturnAttribute implements OptionSourceInterface
{
    protected $_options;
    protected $attribute;

    /**
     * @param Attribute $attribute
     */
    public function __construct(
        Attribute $attribute
    )
    {
        $this->attribute = $attribute;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options[] = [
                'value' => '',
                'label' => '',
            ];
            $attributes = $this->attribute->getCollection()
                ->join('eav_entity_type', 'main_table.entity_type_id=eav_entity_type.entity_type_id', ['entity_type_code'=>'entity_type_code'])
                ->addFieldToFilter('entity_type_code', RmaAttributesManagementInterface::ENTITY_TYPE)
                ->getItems();
            foreach ($attributes as $attribute) {
                $this->_options[] = [
                    'value' => $attribute->getAttributeCode(),
                    'label' => $attribute->getFrontendLabel(),
                ];
            }
        }

        return $this->_options;
    }
}
