<?php

namespace Drop\Pvs\Model\Config\Source;

use Magento\Eav\Model\Attribute;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Rma\Api\RmaAttributesManagementInterface;

class ReturnAttribute implements OptionSourceInterface
{
    protected $_options;
    protected $attribute;

    /**
     * @param Attribute $attribute
     */
    public function __construct(
        Attribute $attribute
    )
    {
        $this->attribute = $attribute;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options[] = [
                'value' => '',
                'label' => '',
            ];
            $attributes = $this->attribute->getCollection()
                ->addFieldToFilter('entity_type_id', RmaAttributesManagementInterface::ATTRIBUTE_SET_ID)
                ->getItems();
            foreach ($attributes as $attribute) {
                $this->_options[] = [
                    'value' => $attribute->getAttributeCode(),
                    'label' => $attribute->getFrontendLabel(),
                ];
            }
        }

        return $this->_options;
    }
}
