<?php


namespace Drop\Pvs\Model;

use Drop\Pvs\Api\Data\XdocetesInterface;
use Drop\Pvs\Model\ResourceModel\Xdocetes as ResourceModel;
use Magento\Framework\Model\AbstractModel;

class Xdocetes extends AbstractModel implements XdocetesInterface
{
    /**
     * @var string
     */
    protected $_eventPrefix = 'drop_pvs_xdocetes_model';

    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @return string|null
     */
    public function getCodSocl(): ?string
    {
        return $this->getData(self::COD_SOCL) === null ? null : (string)$this->getData(self::COD_SOCL);
    }

    /**
     * @param string|null $codSocl
     */
    public function setCodSocl(?string $codSocl): void
    {
        $this->setData(self::COD_SOCL, $codSocl);
    }

    /**
     * @return string|null
     */
    public function getCodDicl(): ?string
    {
        return $this->getData(self::COD_DICL) === null ? null : (string)$this->getData(self::COD_DICL);
    }

    /**
     * @param string|null $codDicl
     */
    public function setCodDicl(?string $codDicl): void
    {
        $this->setData(self::COD_DICL, $codDicl);
    }

    /**
     * @return string|null
     */
    public function getCodDoce(): ?string
    {
        return $this->getData(self::COD_DOCE) === null ? null : (string)$this->getData(self::COD_DOCE);
    }

    /**
     * @param string|null $codDoce
     */
    public function setCodDoce(?string $codDoce): void
    {
        $this->setData(self::COD_DOCE, $codDoce);
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->getData(self::STATUS) === null ? null : (string)$this->getData(self::STATUS);
    }

    /**
     * @param string|null $status
     */
    public function setStatus(?string $status): void
    {
        $this->setData(self::STATUS, $status);
    }

    /**
     * @return string|null
     */
    public function getCodCliFor(): ?string
    {
        return $this->getData(self::COD_CLI_FOR) === null ? null : (string)$this->getData(self::COD_CLI_FOR);
    }

    /**
     * @param string|null $codCliFor
     */
    public function setCodCliFor(?string $codCliFor): void
    {
        $this->setData(self::COD_CLI_FOR, $codCliFor);
    }

    /**
     * @return string|null
     */
    public function getBolla(): ?string
    {
        return $this->getData(self::BOLLA) === null ? null : (string)$this->getData(self::BOLLA);
    }

    /**
     * @param string|null $bolla
     */
    public function setBolla(?string $bolla): void
    {
        $this->setData(self::BOLLA, $bolla);
    }

    /**
     * @return DateTime
     */
    public function getDataBolla(): \DateTime
    {
        return $this->getData(self::DATA_BOLLA);
    }

    /**
     * @param DateTime $dataBolla
     */
    public function setDataBolla(\DateTime $dataBolla): void
    {
        $this->setData(self::DATA_BOLLA, $dataBolla);
    }

    /**
     * @return string|null
     */
    public function getOrdine(): ?string
    {
        return $this->getData(self::ORDINE) === null ? null : (string)$this->getData(self::ORDINE);
    }

    /**
     * @param string|null $ordine
     */
    public function setOrdine(?string $ordine): void
    {
        $this->setData(self::ORDINE, $ordine);
    }

    /**
     * @return string|null
     */
    public function getRigaDoce(): ?string
    {
        return $this->getData(self::RIGA_DOCE) === null ? null : (string)$this->getData(self::RIGA_DOCE);
    }

    /**
     * @param string|null $rigaDoce
     */
    public function setRigaDoce(?string $rigaDoce): void
    {
        $this->setData(self::RIGA_DOCE, $rigaDoce);
    }

    /**
     * @return string|null
     */
    public function getCodArt(): ?string
    {
        return $this->getData(self::COD_ART) === null ? null : (string)$this->getData(self::COD_ART);
    }

    /**
     * @param string|null $codArt
     */
    public function setCodArt(?string $codArt): void
    {
        $this->setData(self::COD_ART, $codArt);
    }

    /**
     * @return float|null
     */
    public function getQtaRiga(): ?float
    {
        return $this->getData(self::QTA_RIGA) === null ? null : (string)$this->getData(self::QTA_RIGA);
    }

    /**
     * @param float|null $qtaRiga
     */
    public function setQtaRiga(?float $qtaRiga): void
    {
        $this->setData(self::QTA_RIGA, $qtaRiga);
    }

    /**
     * @return float|null
     */
    public function getQtaVersata(): ?float
    {
        return $this->getData(self::QTA_VERSATA) === null ? null : (string)$this->getData(self::QTA_VERSATA);
    }

    /**
     * @param float|null $qtaVersata
     */
    public function setQtaVersata(?float $qtaVersata): void
    {
        $this->setData(self::QTA_VERSATA, $qtaVersata);
    }

    /**
     * @return float|null
     */
    public function getQtaPlus(): ?float
    {
        return $this->getData(self::QTA_PLUS) === null ? null : (string)$this->getData(self::QTA_PLUS);
    }

    /**
     * @param float|null $qtaPlus
     */
    public function setQtaPlus(?float $qtaPlus): void
    {
        $this->setData(self::QTA_PLUS, $qtaPlus);
    }

    /**
     * @return string|null
     */
    public function getCodUm(): ?string
    {
        return $this->getData(self::COD_UM) === null ? null : (string)$this->getData(self::COD_UM);
    }

    /**
     * @param string|null $codUm
     */
    public function setCodUm(?string $codUm): void
    {
        $this->setData(self::COD_UM, $codUm);
    }

    /**
     * @return string|null
     */
    public function getCodMcon(): ?string
    {
        return $this->getData(self::COD_MCON) === null ? null : (string)$this->getData(self::COD_MCON);
    }

    /**
     * @param string|null $codMcon
     */
    public function setCodMcon(?string $codMcon): void
    {
        $this->setData(self::COD_MCON, $codMcon);
    }

    /**
     * @return string|null
     */
    public function getCodCmov(): ?string
    {
        return $this->getData(self::COD_CMOV) === null ? null : (string)$this->getData(self::COD_CMOV);
    }

    /**
     * @param string|null $codCmov
     */
    public function setCodCmov(?string $codCmov): void
    {
        $this->setData(self::COD_CMOV, $codCmov);
    }

    /**
     * @return string|null
     */
    public function getDescArt(): ?string
    {
        return $this->getData(self::DESC_ART) === null ? null : (string)$this->getData(self::DESC_ART);
    }

    /**
     * @param string|null $descArt
     */
    public function setDescArt(?string $descArt): void
    {
        $this->setData(self::DESC_ART, $descArt);
    }

    /**
     * @return string|null
     */
    public function getFlNew(): ?string
    {
        return $this->getData(self::FL_NEW) === null ? null : (string)$this->getData(self::FL_NEW);
    }

    /**
     * @param string|null $flNew
     */
    public function setFlNew(?string $flNew): void
    {
        $this->setData(self::FL_NEW, $flNew);
    }

    /**
     * @return string|null
     */
    public function getDescCmov(): ?string
    {
        return $this->getData(self::DESC_CMOV) === null ? null : (string)$this->getData(self::DESC_CMOV);
    }

    /**
     * @param string|null $descCmov
     */
    public function setDescCmov(?string $descCmov): void
    {
        $this->setData(self::DESC_CMOV, $descCmov);
    }

    /**
     * @return DateTime
     */
    public function getCreatedAt(): \DateTime
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @param DateTime|null $createdAt
     */
    public function setCreatedAt(?\DateTime $createdAt): void
    {
        $this->setData(self::CREATED_AT, $createdAt);
    }

}