<?php

namespace Drop\Pvs\Model\Rma;

use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Logger\Logger;
use Magento\Rma\Model\Item\Attribute\Source\Status as ItemStatus;
use Magento\Rma\Model\Rma\Source\Status as RmaStatus;
use Magento\Rma\Model\Rma;

class Authorize
{

    private $configuration;
    private $logger;

    /**
     * Authorize constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param Logger $logger
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        Logger $logger
    )
    {
        $this->configuration = $configurationHelper;
        $this->logger = $logger;
    }

    /**
     * @param Rma $rma
     * @return bool
     */
    public function execute(Rma $rma): bool
    {
        if (
            !$this->configuration->isReturnAutomaticAuthorization() ||
            $rma->getStatus() != RmaStatus::STATE_PENDING
        ) {
            return false;
        }

        foreach ($rma->getItems() as $item) {
            try {
                $item->setQtyAuthorized($item->getQtyRequested());
                $item->setStatus(ItemStatus::STATE_AUTHORIZED);
                $item->save();
            } catch (\Exception $e) {
                $this->logger->error("[AUTHORIZE RETURN ITEM] - {$rma->getIncrementId()} ERROR: {$e->getMessage()}");
            }

        }

        try {
            $rma->setStatus(RmaStatus::STATE_AUTHORIZED)->setIsUpdate(1);
            $rma->save();
        } catch (\Exception $e) {
            $this->logger->error("[AUTHORIZE RETURN] - {$rma->getIncrementId()} ERROR: {$e->getMessage()}");
            return false;
        }

        return true;
    }
}
