<?php


namespace Drop\Pvs\Api;

use Drop\Pvs\Api\Data\XdocetesInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

interface XdocetesRepositoryInterface
{
    /**
     * @param int $id
     * @return \Drop\Pvs\Api\Data\XdocetesInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($id);

    /**
     * @param \Drop\Pvs\Api\Data\XdocetesInterface $xdocetes
     * @return \Drop\SSO\Api\Data\AccountInterface
     */
    public function save(XdocetesInterface $xdocetes);

    /**
     * @param \Drop\Pvs\Api\Data\XdocetesInterface $xdocetes
     * @return void
     */
    public function delete(XdocetesInterface $xdocetes);

    /**
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Drop\Pvs\Api\Data\XdocetesSearchResultInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);
}