<?php


namespace Drop\Pvs\Block\Adminhtml\Form\Field;

use Magento\Framework\View\Element\Context;
use Magento\Directory\Model\ResourceModel\Country\Collection;
use Magento\Framework\View\Element\Html\Select;

class CountryColumn extends Select
{
    protected $countryCollection;

    public function __construct(
        Collection $countryCollection,
        Context $context,
        array $data = []
    )
    {
        $this->countryCollection = $countryCollection;
        parent::__construct($context, $data);
    }

    /**
     * Set "name" for <select> element
     *
     * @param string $value
     * @return $this
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * Set "id" for <select> element
     *
     * @param $value
     * @return $this
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }

    /**
     * Render block HTML
     *
     * @return string
     */
    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->getSourceOptions());
        }
        return parent::_toHtml();
    }

    /**
     * @return array
     */
    private function getSourceOptions(): array
    {
        return array_merge(
            [["value" => "0", "label" => ""]],
            $this->countryCollection->loadData()->toOptionArray(false)
        );
    }
}
