<?php


namespace Drop\Pvs\Model\Ftp;


use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Logger\Logger;
use Magento\Framework\Filesystem\Io\Ftp;

class Modifier
{
    const OLD_DIR = "OLD";
    const DONE_DIR = "DONE";

    private $configuration;
    private $utilities;
    private $ftp;
    private $logger;

    /**
     * Modifier constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param UtilitiesHelper $utilitiesHelper
     * @param Ftp $ftp
     * @param Logger $logger
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        UtilitiesHelper $utilitiesHelper,
        Ftp $ftp,
        Logger $logger
    )
    {
        $this->configuration = $configurationHelper;
        $this->utilities = $utilitiesHelper;
        $this->ftp = $ftp;
        $this->logger = $logger;
    }

    /**
     * @param $ftpPath
     */
    public function connect($ftpPath)
    {
        $ftpParams = [
            'host'     => $this->configuration->getFtpHost(),
            'port'     => $this->configuration->getFtpPort(),
            'user'     => $this->configuration->getFtpUsername(),
            'password' => $this->configuration->getFtpPassword(),
            'path'     => $ftpPath,
            'passive'  => true
        ];
        try {
            $this->ftp->open($ftpParams);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->ftp->close();
        }
    }

    /**
     * @param $path
     */
    public function moveToOld($path)
    {
        $expl = explode('/', $path);
        $filename = array_pop($expl);
        $newPath = implode('/', $expl) . "/" . self::OLD_DIR . "/" . $filename;
        $this->move($path, $newPath);
    }

    /**
     * @param $path
     */
    public function moveToDone($path)
    {
        $expl = explode('/', $path);
        $filename = array_pop($expl);
        $newPath = implode('/', $expl) . "/" . self::DONE_DIR . "/" . $filename;
        $this->move($path, $newPath);
    }

    /**
     * @param $oldPath
     * @param $newPath
     */
    public function move($oldPath, $newPath)
    {
        $this->connect($this->configuration->getFtpRootPath());
        try {
            $this->ftp->mv($oldPath, $newPath);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->ftp->close();
        }
    }

    /**
     * @param $path
     */
    public function delete($path)
    {
        $this->connect($this->configuration->getFtpRootPath());

        try {
            $this->ftp->rm($path);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->ftp->close();
        }
    }

}
