<?php


namespace Drop\Pvs\Cron\Export;

use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Logger\Logger;
use Drop\Pvs\Model\Consumer\Export\Restock as Consumer;
use Drop\Pvs\Model\Ftp\Downloader;
use Drop\Pvs\Model\Publisher;
use Magento\Authorization\Model\UserContextInterface;
use Magento\Framework\Bulk\BulkManagementInterface;
use Magento\Framework\Bulk\OperationInterface;
use Magento\Framework\DataObject\IdentityGeneratorInterface;
use Magento\Framework\MessageQueue\PublisherInterface;
use Magento\Framework\Serialize\SerializerInterface;

class Restock
{
    const TOPIC_NAME = 'pvs.export.restock';

    private $publisher;
    private $consumer;
    private $configuration;
    private $downloader;
    private $fileInterface;

    /**
     * Restock constructor.
     * @param Publisher $publisher
     * @param Consumer $consumer
     * @param ConfigurationHelper $configurationHelper
     * @param Downloader $downloader
     * @param FileInterface $fileInterface
     */
    public function __construct(
        Publisher $publisher,
        Consumer $consumer,
        ConfigurationHelper $configurationHelper,
        Downloader $downloader,
        FileInterface $fileInterface
    )
    {
        $this->publisher = $publisher;
        $this->consumer = $consumer;
        $this->configuration = $configurationHelper;
        $this->downloader = $downloader;
        $this->fileInterface = $fileInterface;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled() || !$this->configuration->isCommunicationEnabled()) {
            return;
        }

        if (!$files = $this->downloader->list($this->configuration->getRestockFilename(), $this->configuration->getFtpRestockDir())) {
            return;
        }

        $publisherData = $this->getPublisherData($files);

        if (!$this->configuration->isJobEnabled()) {
            $this->consumer->process($publisherData);
            return;
        }

        $this->publisher->publish(self::TOPIC_NAME, $publisherData, "Export Restock");
    }

    /**
     * @param $files
     * @param bool $canDeleteFiles
     * @return FileInterface
     */
    public function getPublisherData($files, bool $canDeleteFiles = false): FileInterface
    {
        $this->fileInterface->setFiles($files);
        $this->fileInterface->setCanDeleteFiles($canDeleteFiles);

        return $this->fileInterface;
    }
}
