<?php


namespace Drop\Pvs\Model\Config\Source;


use Magento\Rma\Model\Rma\Source\Status;
use Magento\Framework\Data\OptionSourceInterface;

class RmaStatusAttribute implements OptionSourceInterface
{
    const RMA_STATUSES = [
        Status::STATE_PENDING,
        Status::STATE_AUTHORIZED,
        Status::STATE_PARTIAL_AUTHORIZED,
        Status::STATE_RECEIVED,
        Status::STATE_RECEIVED_ON_ITEM,
        Status::STATE_APPROVED_ON_ITEM,
        Status::STATE_REJECTED_ON_ITEM,
        Status::STATE_CLOSED,
        Status::STATE_PROCESSED_CLOSED
    ];

    protected $_options;
    protected $status;

    /**
     * RmaStatusAttribute constructor.
     * @param Status $status
     */
    public function __construct(
        Status $status
    )
    {
        $this->status = $status;
    }

    /**
     * @return \string[][]
     */
    public function toOptionArray(): array
    {
        if (!$this->_options) {
            $this->_options = [
                [
                    'value' => '',
                    'label' => '',
                ],
            ];
            foreach (self::RMA_STATUSES as $status) {
                $this->_options[] = [
                    'value' => $status,
                    'label' => $this->status->getItemLabel($status),
                ];
            }
        }

        return $this->_options;
    }
}
