<?php


namespace Drop\Pvs\Cron\Export;

use Drop\Pvs\Api\Export\RmaInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Rma\Api\RmaRepositoryInterface;
use Magento\Framework\MessageQueue\PublisherInterface;

class Rma
{
    const TOPIC_NAME = 'pvs.export.rma';

    private $searchCriteriaBuilder;
    private $configuration;
    private $rmaRepository;
    private $publisher;
    private $rmaInterface;

    /**
     * Order constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param RmaRepositoryInterface $rmaRepository
     * @param PublisherInterface $publisher
     * @param RmaInterface $rmaInterface
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        RmaRepositoryInterface $rmaRepository,
        PublisherInterface $publisher,
        RmaInterface $rmaInterface
    )
    {
        $this->configuration = $configurationHelper;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->rmaRepository = $rmaRepository;
        $this->publisher = $publisher;
        $this->rmaInterface = $rmaInterface;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled() || !$this->configuration->isCommunicationEnabled()) {
            return;
        }

        // recupero tutti i resi non esportati
        $this->searchCriteriaBuilder->addFilter("drop_pvs_exported", 0);
        if (!$rmas = $this->rmaRepository->getList($this->searchCriteriaBuilder->create())->getItems()) {
            return;
        }

        foreach ($rmas as $rma) {
            // creo job per l'esportazione
            $this->publisher->publish(self::TOPIC_NAME, $this->getPublisherData($rma));
        }
    }

    /**
     * @param $rma
     * @param bool $saveLocal
     * @param bool $saveToFtp
     * @param bool $forced
     * @return RmaInterface
     */
    public function getPublisherData($rma, bool $saveLocal = false, bool $saveToFtp = true, bool $forced = false): RmaInterface
    {
        $this->rmaInterface->setRmaId($rma->getEntityId());
        $this->rmaInterface->setSaveLocal($saveLocal);
        $this->rmaInterface->setSaveToFtp($saveToFtp);
        $this->rmaInterface->setIsForced($forced);

        return $this->rmaInterface;
    }
}
