<?php


namespace Drop\Pvs\Model\Consumer\Export;


use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Logger\Logger;
use Drop\Pvs\Model\Ftp\Downloader;
use Drop\Pvs\Model\Ftp\Modifier;
use Drop\Pvs\Model\Ftp\Uploader;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;

class Restock
{
    private $configuration;
    private $utilities;
    private $logger;
    private $downloader;
    private $modifier;
    private $uploader;
    private $productsRepositoryInterface;
    private $searchCriteriaBuilder;

    public function __construct(
        ConfigurationHelper $configurationHelper,
        UtilitiesHelper $utilitiesHelper,
        Logger $logger,
        Downloader $downloader,
        Modifier $modifier,
        Uploader $uploader,
        ProductRepositoryInterface $productsRepositoryInterface,
        SearchCriteriaBuilder $searchCriteriaBuilder
    )
    {
        $this->configuration = $configurationHelper;
        $this->utilities = $utilitiesHelper;
        $this->logger = $logger;
        $this->downloader = $downloader;
        $this->modifier = $modifier;
        $this->uploader = $uploader;
        $this->productsRepositoryInterface = $productsRepositoryInterface;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @param FileInterface $data
     * @return bool
     */
    public function process(FileInterface $data)
    {
        $this->logger->info("Exporting Restock");

        // genero XDOCE
        $this->logger->info("Generate XDOCE [Restock]");
        $restockData = $this->generateData($data->getFiles());

        $this->saveFiles($restockData, $data);

        return true;
    }

    /**
     * @param $files
     * @return array
     */
    public function generateData($files): array
    {
        $data = [];
        foreach ($files as $file) {
            $rows = $this->utilities->getAssocArrayFromFile($this->configuration->getFtpRestockDir(), $file);
            foreach ($rows as $row) {
                $this->searchCriteriaBuilder->addFilter($this->configuration->getEanAttributeCode(), $row[$this->configuration->getRestockFileEanField()]);
                if (!$product = $this->productsRepositoryInterface->getList($this->searchCriteriaBuilder->create())->getFirstItem()) {
                    continue;
                }

                $data[] = [
                    'COD_SOCL'    => $this->configuration->getCodSocl(),
                    'COD_DICL'    => $this->configuration->getCodDicl(),
                    'COD_ART'     => $product->getSku(),
                    'QTA_RIGA'    => $row[$this->configuration->getRestockFileQtyField()],
                    'COD_UM'      => 'PZ',
                    'COD_CMOV'    => 'CAR',
                    'COD_CLI_FOR' => $this->configuration->getCodCliFor(),
                    'BOLLA'       => $row[$this->configuration->getRestockFileDdtNumberField()],
                    'DATA_BOLLA'  => $row[$row[$this->configuration->getRestockFileDdtDateField()]],
                ];
            }
        }

        return $data;
    }

    /**
     * @param $content
     * @param $data
     */
    public function saveFiles($content, $data)
    {
        // gestione file caricato dal cliente
        //se $canDeleteFiles a true, elimino il file, sennò lo sposto sulla sotto cartella!
        if ($data->getCanDeleteFiles()) {
            foreach ($data->getFiles() as $file) {
                $this->modifier->delete($file);
            }
        } else {
            foreach ($data->getFiles() as $file) {
                $this->modifier->moveToOld($file);
            }
        }


        $filename = $this->utilities->completeFilenameWithDateTime($this->configuration->getQtyMovementsFilename());
        $this->uploader->execute($filename, $content);
    }
}
