<?php

namespace Drop\Pvs\Console\Command\Rma;

use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Rma\Model\Config;
use Drop\Pvs\Model\Rma\Status\History;
use Drop\Pvs\Model\Rma\Authorize as Action;
use Magento\Rma\Api\RmaRepositoryInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class Authorize extends Command
{
    const RMA_ENTITY_ID = 'entity-id';

    protected $appState;
    protected $rmaRepository;
    protected $authorize;

    /**
     * SendMail constructor.
     * @param State $appState
     * @param RmaRepositoryInterface $rmaRepository
     * @param Action $authorize
     */
    public function __construct(
        State $appState,
        RmaRepositoryInterface $rmaRepository,
        Action $authorize
    )
    {
        $this->appState = $appState;
        $this->rmaRepository = $rmaRepository;
        $this->authorize = $authorize;
        parent::__construct();
    }

    protected function configure()
    {
        $options = [
            new InputOption(
                self::RMA_ENTITY_ID,
                null,
                InputOption::VALUE_REQUIRED,
                'get rma id'
            ),
        ];
        $this->setName('drop:pvs:rma:authorize');
        $this->setDescription('Manual rma authorize');
        $this->setDefinition($options);
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->appState->setAreaCode(Area::AREA_ADMINHTML);

        $rmaId = $input->getOption(self::RMA_ENTITY_ID);

        if (!$rma = $this->rmaRepository->get($rmaId)) {
            $output->writeln('<error>No rma was found.</error>');
            return;
        }

        $this->authorize->execute($rma);
    }
}
