<?php

namespace Drop\Pvs\Api\Data;

interface XdocetesInterface
{
    /**
     * String constants for property names
     */
    const ENTITY_ID = "entity_id";
    const COD_SOCL = "cod_socl";
    const COD_DICL = "cod_dicl";
    const COD_DOCE = "cod_doce";
    const STATUS = "status";
    const COD_CLI_FOR = "cod_cli_for";
    const BOLLA = "bolla";
    const DATA_BOLLA = "data_bolla";
    const ORDINE = "ordine";
    const RIGA_DOCE = "riga_doce";
    const COD_ART = "cod_art";
    const QTA_RIGA = "qta_riga";
    const QTA_VERSATA = "qta_versata";
    const QTA_PLUS = "qta_plus";
    const COD_UM = "cod_um";
    const COD_MCON = "cod_mcon";
    const COD_CMOV = "cod_cmov";
    const DESC_ART = "desc_art";
    const FL_NEW = "fl_new";
    const DESC_CMOV = "desc_cmov";
    const CREATED_AT = "created_at";

    /**
     * @return string|null
     */
    public function getCodSocl(): ?string;

    /**
     * @param string|null $codSocl
     */
    public function setCodSocl(?string $codSocl): void;

    /**
     * @return string|null
     */
    public function getCodDicl(): ?string;

    /**
     * @param string|null $codDicl
     */
    public function setCodDicl(?string $codDicl): void;

    /**
     * @return string|null
     */
    public function getCodDoce(): ?string;

    /**
     * @param string|null $codDoce
     */
    public function setCodDoce(?string $codDoce): void;

    /**
     * @return string|null
     */
    public function getStatus(): ?string;

    /**
     * @param string|null $status
     */
    public function setStatus(?string $status): void;

    /**
     * @return string|null
     */
    public function getCodCliFor(): ?string;

    /**
     * @param string|null $codCliFor
     */
    public function setCodCliFor(?string $codCliFor): void;

    /**
     * @return string|null
     */
    public function getBolla(): ?string;

    /**
     * @param string|null $bolla
     */
    public function setBolla(?string $bolla): void;

    /**
     * @return DateTime
     */
    public function getDataBolla(): \DateTime;

    /**
     * @param DateTime $dataBolla
     */
    public function setDataBolla(\DateTime $dataBolla): void;

    /**
     * @return string|null
     */
    public function getOrdine(): ?string;

    /**
     * @param string|null $ordine
     */
    public function setOrdine(?string $ordine): void;

    /**
     * @return string|null
     */
    public function getRigaDoce(): ?string;

    /**
     * @param string|null $rigaDoce
     */
    public function setRigaDoce(?string $rigaDoce): void;

    /**
     * @return string|null
     */
    public function getCodArt(): ?string;

    /**
     * @param string|null $codArt
     */
    public function setCodArt(?string $codArt): void;

    /**
     * @return float|null
     */
    public function getQtaRiga(): ?float;

    /**
     * @param float|null $qtaRiga
     */
    public function setQtaRiga(?float $qtaRiga): void;

    /**
     * @return float|null
     */
    public function getQtaVersata(): ?float;

    /**
     * @param float|null $qtaVersata
     */
    public function setQtaVersata(?float $qtaVersata): void;

    /**
     * @return float|null
     */
    public function getQtaPlus(): ?float;

    /**
     * @param float|null $qtaPlus
     */
    public function setQtaPlus(?float $qtaPlus): void;

    /**
     * @return string|null
     */
    public function getCodUm(): ?string;

    /**
     * @param string|null $codUm
     */
    public function setCodUm(?string $codUm): void;

    /**
     * @return string|null
     */
    public function getCodMcon(): ?string;

    /**
     * @param string|null $codMcon
     */
    public function setCodMcon(?string $codMcon): void;

    /**
     * @return string|null
     */
    public function getCodCmov(): ?string;

    /**
     * @param string|null $codCmov
     */
    public function setCodCmov(?string $codCmov): void;

    /**
     * @return string|null
     */
    public function getDescArt(): ?string;

    /**
     * @param string|null $descArt
     */
    public function setDescArt(?string $descArt): void;

    /**
     * @return string|null
     */
    public function getFlNew(): ?string;

    /**
     * @param string|null $flNew
     */
    public function setFlNew(?string $flNew): void;

    /**
     * @return string|null
     */
    public function getDescCmov(): ?string;

    /**
     * @param string|null $descCmov
     */
    public function setDescCmov(?string $descCmov): void;

    /**
     * @return DateTime
     */
    public function getCreatedAt(): \DateTime;

    /**
     * @param DateTime|null $createdAt
     */
    public function setCreatedAt(?\DateTime $createdAt): void;
}