<?php


namespace Drop\Pvs\Model\Consumer\Import;


use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Logger\Logger;
use Drop\Pvs\Model\Ftp\Modifier;

class DeletedOrder
{
    const EMAIL_TEMPLATE = "drop_pvs_canceled_order";

    private $logger;
    private $configuration;
    private $utilities;
    private $modifier;


    public function __construct(
        Logger $logger,
        ConfigurationHelper $configurationHelper,
        UtilitiesHelper $utilitiesHelper,
        Modifier $modifier
    )
    {
        $this->logger = $logger;
        $this->configuration = $configurationHelper;
        $this->utilities = $utilitiesHelper;
        $this->modifier = $modifier;
    }

    public function process(FileInterface $data)
    {
        if (!count($data->getFiles()) || !$this->configuration->isEmailEnabled()) {
            return;
        }

        foreach ($data->getFiles() as $file) {
            if (trim($this->configuration->getFtpRootPath() != "")) {
                $file = str_replace($this->configuration->getFtpRootPath() . "/", "", $file);
            }
            $expl = explode("/", $file);
            $filename = array_pop($expl);
            $this->logger->info("elaborazione XORDC_STOCK - {$filename}");

            $rows = [];
            $csvData = $this->utilities->getAssocArrayFromFile(implode("/", $expl), $filename, ";", "\r\n");
            foreach ($csvData as $key => $row) {
                if (!isset($row['COD_ORDC'])) {
                    continue;
                }

                foreach ($this->configuration->getDeletedOrderFileColumns() as $column){
                    $rows[$key][$column->column] = $row[$column->column];
                }
            }

            if (count($rows)) {
                $templateVars = ["rows" => $rows];
                $replyTo = trim($this->configuration->getCanceledOrderReplyToEmail()) != '' ? $this->configuration->getCanceledOrderReplyToEmail() : null;
                $this->utilities->sendMail(self::EMAIL_TEMPLATE, $templateVars, $this->configuration->getCanceledOrderEmail(), $replyTo);
            }

            $this->manageFtpFile($file, $data->getCanDeleteFiles());
        }
    }

    /**
     * @param $filename
     * @param $canDeleteFile
     */
    protected function manageFtpFile($filename, $canDeleteFile)
    {
        if ($canDeleteFile) {
            $this->logger->info("delete file - {$filename}");
            $this->modifier->delete($filename);
            return;
        }

        $this->logger->info("move file to DONE - {$filename}");
        $this->modifier->moveToDone($filename);
    }
}
