<?php


namespace Drop\Pvs\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        $connection = $installer->getConnection();

        if ($connection->tableColumnExists('sales_order', 'drop_pvs_exported')) {
            $connection->modifyColumn(
                $setup->getTable('sales_order'),
                'drop_pvs_exported',
                [
                    'type'     => Table::TYPE_BOOLEAN,
                    'length'   => 1,
                    'default'  => 0,
                    'nullable' => false,
                    'comment'  => 'Check if order is exported to Pvs'
                ],
            );
        }

        if ($connection->tableColumnExists('magento_rma', 'drop_pvs_exported')) {
            $connection->modifyColumn(
                $setup->getTable('magento_rma'),
                'drop_pvs_exported',
                [
                    'type'     => Table::TYPE_BOOLEAN,
                    'length'   => 1,
                    'default'  => 0,
                    'nullable' => false,
                    'comment'  => 'Check if order is exported to Pvs'
                ],
            );
        }
    }
}
