<?php


namespace Drop\Pvs\Model\Config\Source;


use Magento\Framework\Data\OptionSourceInterface;
use Magento\Catalog\Model\ResourceModel\Eav\Attribute;

class ProductAttribute implements OptionSourceInterface
{
    protected $_options;
    protected $attributeFactory;

    /**
     * OrderStatuses constructor.
     * @param Attribute $attributeFactory
     */
    public function __construct(
        Attribute $attributeFactory
    )
    {
        $this->attributeFactory = $attributeFactory;
    }

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        if (!$this->_options) {
            $this->_options[] = [
                'value' => '',
                'label' => '',
            ];
            $attributes = $this->attributeFactory->getCollection()->addFieldToFilter(\Magento\Eav\Model\Entity\Attribute\Set::KEY_ENTITY_TYPE_ID, 4);
            foreach ($attributes as $attribute) {
                $this->_options[] = [
                    'value' => $attribute->getAttributeCode(),
                    'label' => $attribute->getFrontendLabel(),
                ];
            }
        }

        return $this->_options;
    }
}
