<?php


namespace Drop\Pvs\Plugin;


use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Logger\Logger;
use Magento\Framework\Exception\LocalizedException;
use Magento\Rma\Helper\Data;
use Magento\Sales\Api\OrderRepositoryInterface;

class RmaDataHelper
{
    protected $configuration;
    protected $orderRepository;
    protected $logger;

    /**
     * RmaDataHelper constructor.
     * @param ConfigurationHelper $configurationHelper
     * @param OrderRepositoryInterface $orderRepository
     * @param Logger $logger
     */
    public function __construct(
        ConfigurationHelper $configurationHelper,
        OrderRepositoryInterface $orderRepository,
        Logger $logger
    )
    {
        $this->configuration = $configurationHelper;
        $this->orderRepository = $orderRepository;
        $this->logger = $logger;
    }

    /**
     * @param Data $subject
     * @param $result
     * @param $order
     * @return false|mixed|void
     * @throws LocalizedException
     */
    public function afterCanCreateRma(Data $subject, $result, $order)
    {
        // se non è attivo pvs
        // se non è attivo il controllo dei giorni
        // se magento nega la possibilità
        // ==> torno il risultato di magento
        if (
            !$this->configuration->isEnabled()
            || !$this->configuration->isRmaDayLimitEnabled()
            || !$result
        ) {
            return $result;
        }

        if (!is_object($order)) {
            $order = $this->orderRepository->get($order);
        }

        if (!$order) {
            $this->logger->error("[CAN CREATE RMA] error, can't find order");
            throw new LocalizedException(__('Please check this order for errors.'));
            return;
        }

        if (!$order->getDropPvsDeliveryDate()) {
            return $result;
        }

        $d1 = new \DateTime($order->getDropPvsDeliveryDate());
        $d2 = new \DateTime(date('Y-m-d'));
        $difference = (int)$d1->diff($d2)->format("%a");

        if ($difference > (int)$this->configuration->getRmaDayLimit()) {
            return false;
        }

        return $result;
    }
}
