<?php


namespace Drop\Pvs\Model;


use Drop\Pvs\Api\Data\XdocetesInterface;
use Drop\Pvs\Api\XdocetesRepositoryInterface;
use Drop\Pvs\Api\Data\XdocetesInterfaceFactory;
use Drop\Pvs\Model\ResourceModel\Xdocetes\CollectionFactory;
use Drop\Pvs\Api\Data\XdocetesSearchResultInterfaceFactory;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Api\SearchCriteriaInterface;

class XdocetesRepository implements XdocetesRepositoryInterface
{
    private $xdocetesInterfaceFactory;
    private $collectionFactory;
    private $resource;
    private $xdocetesSearchResult;
    private $collectionProcessor;

    public function __construct(
        XdocetesInterfaceFactory $xdocetesInterfaceFactory,
        CollectionFactory $collectionFactory,
        \Drop\Pvs\Model\ResourceModel\Xdocetes $xdocetesResourceModel,
        XdocetesSearchResultInterfaceFactory $xdocetesSearchResultInterfaceFactory,
        CollectionProcessorInterface $collectionProcessor
    )
    {
        $this->xdocetesInterfaceFactory = $xdocetesInterfaceFactory;
        $this->collectionFactory = $collectionFactory;
        $this->resource = $xdocetesResourceModel;
        $this->xdocetesSearchResult = $xdocetesSearchResultInterfaceFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @param int $id
     * @return \Drop\Pvs\Api\Data\XdocetesInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($id)
    {
        $xdocetes = $this->xdocetesInterfaceFactory->create();
        $this->resource->load($xdocetes, $id, XdocetesInterface::ENTITY_ID);
        if (!$xdocetes->getId()) {
            throw new NoSuchEntityException(__('Unable to find xdocetes with ID "%1"', $id));
        }

        return $xdocetes;
    }

    /**
     * @param \Drop\Pvs\Api\Data\XdocetesInterface $xdocetes
     * @return \Drop\SSO\Api\Data\AccountInterface
     * @throws \Magento\Framework\Exception\AlreadyExistsException
     */
    public function save(XdocetesInterface $xdocetes)
    {
        /** @var Xdocetes $xdocetes */
        $this->resource->save($xdocetes);
        return $xdocetes;
    }

    /**
     * @param \Drop\Pvs\Api\Data\XdocetesInterface $xdocetes
     * @throws \Exception
     */
    public function delete(XdocetesInterface $xdocetes)
    {
        /** @var Xdocetes $xdocetes */
        $this->resource->delete($xdocetes);
    }

    /**
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Drop\Pvs\Api\Data\XdocetesSearchResultInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $collection = $this->collectionFactory->create();
        $this->collectionProcessor->process($searchCriteria, $collection);
        $searchResults = $this->xdocetesSearchResult->create();

        $searchResults->setSearchCriteria($searchCriteria);
        $searchResults->setItems($collection->getItems());

        return $searchResults;
    }
}