<?php


namespace Drop\Pvs\Model\Consumer\Import;


use Drop\Pvs\Model\XdocetesFactory;
use Drop\Pvs\Model\Xdocetes as XdocetesModel;
use Drop\Pvs\Api\Data\XdocetesInterfaceFactory;
use Drop\Pvs\Api\XdocetesRepositoryInterface;
use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Helper\UtilitiesHelper;
use Drop\Pvs\Logger\Logger;
use Drop\Pvs\Model\Ftp\Modifier;
use Drop\SizeGuide\Model\Data\SizeGuide as SizeGuideModel;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\File\Csv;
use Magento\Framework\Filesystem\Io\File;
use Magento\InventoryApi\Api\Data\SourceItemInterface;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;

class Xdocetes
{

    private $logger;
    private $configuration;
    private $utilities;
    private $modifier;
    private $xdocetesInterfaceFactory;
    private $xdocetesRepository;
    private $xdocetesFactory;
    protected $resource;

    /**
     * Xdocetes constructor.
     * @param Logger $logger
     * @param ConfigurationHelper $configurationHelper
     * @param UtilitiesHelper $utilitiesHelper
     * @param Modifier $modifier
     * @param XdocetesInterfaceFactory $xdocetesInterfaceFactory
     * @param XdocetesRepositoryInterface $xdocetesRepository
     * @param XdocetesFactory $xdocetesFactory
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(
        Logger $logger,
        ConfigurationHelper $configurationHelper,
        UtilitiesHelper $utilitiesHelper,
        Modifier $modifier,
        XdocetesInterfaceFactory $xdocetesInterfaceFactory,
        XdocetesRepositoryInterface $xdocetesRepository,
        XdocetesFactory $xdocetesFactory,
        ResourceConnection $resourceConnection
    )
    {
        $this->logger = $logger;
        $this->configuration = $configurationHelper;
        $this->utilities = $utilitiesHelper;
        $this->modifier = $modifier;
        $this->xdocetesInterfaceFactory = $xdocetesInterfaceFactory;
        $this->xdocetesRepository = $xdocetesRepository;
        $this->xdocetesFactory = $xdocetesFactory;
        $this->resource = $resourceConnection;
    }

    /**
     * @param FileInterface $data
     */
    public function process(FileInterface $data)
    {
        if (!count($data->getFiles())) {
            return;
        }

        foreach ($data->getFiles() as $xdocetesFile) {
            if (trim($this->configuration->getFtpRootPath() != "")) {
                $xdocetesFile = str_replace($this->configuration->getFtpRootPath() . "/", "", $xdocetesFile);
            }
            $expl = explode("/", $xdocetesFile);
            $filename = array_pop($expl);
            $this->logger->info("elaborazione XDOCE - {$filename}");
            $csvData = $this->utilities->getAssocArrayFromFile(implode("/", $expl), $filename, ";", "\r\n");
            foreach ($csvData as $row) {
                if (!isset($row['COD_SOCL']) || trim($row['COD_SOCL']) == "") {
                    continue;
                }

                switch ($row['COD_CMOV']) {
                    case 'RESO':
                        $this->processRmaResponse($row);
                        break;
                    case 'CAR':
                        $this->processRestockResponse($row);
                        break;
                }
            }

            $this->manageFtpFile($xdocetesFile, $data->getCanDeleteFiles());
        }
    }

    public function processRmaResponse($data)
    {
        //TODO: attualmente non faccio niente
    }

    /**
     * @param $data
     * @throws \Exception
     */
    public function processRestockResponse($data)
    {
        $dateExpl = explode("/", $data['DATA_BOLLA']);
        $elaboratedDataBolla = "{$dateExpl[2]}-{$dateExpl[1]}-{$dateExpl[0]}";
//        $itemCollection = $this->xdocetesFactory->create()->getCollection();
//        $itemCollection->addFilter(XdocetesModel::BOLLA, $data["BOLLA"]);
//        $itemCollection->addFilter(XdocetesModel::DATA_BOLLA, $elaboratedDataBolla);
//        $itemCollection->addFilter(XdocetesModel::ORDINE, $data["ORDINE"]);
//        $itemCollection->addFilter(XdocetesModel::COD_ART, $data["COD_ART"]);
//        $itemCollection->addFilter(XdocetesModel::COD_MCON, $data["COD_MCON"]);
//        $itemCollection->addFilter(XdocetesModel::COD_CMOV, $data["COD_CMOV"]);
        $sql = "
        SELECT *
        FROM drop_pvs_xdocetes
        WHERE " . XdocetesModel::BOLLA . "='{$data['BOLLA']}' and
         " . XdocetesModel::DATA_BOLLA . "='{$elaboratedDataBolla}' and
         " . XdocetesModel::ORDINE . "='{$data["ORDINE"]}' and
         " . XdocetesModel::COD_ART . "='{$data["COD_ART"]}' and
         " . XdocetesModel::COD_MCON . "='{$data["COD_MCON"]}' and
         " . XdocetesModel::COD_CMOV . "='{$data["COD_CMOV"]}'
        ";
        $connection = $this->resource->getConnection();
        $itemCollection = $connection->fetchAll($sql);
        if (count($itemCollection) > 0) {
            // record già registrato
            return;
        }

        $datetimeDataBolla = (new \DateTime($elaboratedDataBolla))->format('Y-m-d');
        $createdAt = (new \DateTime())->format('Y-m-d H:i:s');

//        $xdocetes = $this->xdocetesInterfaceFactory->create();
//        $xdocetes->setCodSocl($data['COD_SOCL']);
//        $xdocetes->setCodDicl($data['COD_DICL']);
//        $xdocetes->setCodDoce($data['COD_DOCE']);
//        $xdocetes->setStatus($data['STATUS']);
//        $xdocetes->setCodCliFor($data['COD_CLI_FOR']);
//        $xdocetes->setBolla($data['BOLLA']);
//        $xdocetes->setDataBolla($datetimeDataBolla);
//        $xdocetes->setOrdine($data['ORDINE']);
//        $xdocetes->setRigaDoce($data['RIGA_DOCE']);
//        $xdocetes->setCodArt($data['COD_ART']);
//        $xdocetes->setQtaRiga($data['QTA_RIGA']);
//        $xdocetes->setQtaVersata($data['QTA_VERSATA']);
//        $xdocetes->setQtaPlus($data['QTA_PLUS']);
//        $xdocetes->setCodUm($data['COD_UM']);
//        $xdocetes->setCodMcon($data['COD_MCON']);
//        $xdocetes->setCodCmov($data['COD_CMOV']);
//        $xdocetes->setDescArt($data['DESC_ART']);
//        $xdocetes->setFlNew($data['FL_NEW']);
//        $xdocetes->setDescMcon($data['DESC_MCON']);
//        $xdocetes->setCreatedAt($createdAt);
//        $this->xdocetesRepository->save($xdocetes);

        $sql = "
                INSERT INTO drop_pvs_xdocetes (cod_socl,cod_dicl,cod_doce,status,cod_cli_for,bolla,data_bolla,ordine,riga_doce,cod_art,qta_riga,qta_versata,
                   qta_plus,cod_um,cod_mcon,cod_cmov,desc_art,fl_new,desc_mcon,created_at)
                VALUES ('{$data['COD_SOCL']}','{$data['COD_DICL']}','{$data['COD_DOCE']}','{$data['STATUS']}','{$data['COD_CLI_FOR']}','{$data['BOLLA']}',
                        '{$datetimeDataBolla}','{$data['ORDINE']}','{$data['RIGA_DOCE']}','{$data['COD_ART']}','{$data['QTA_RIGA']}','{$data['QTA_VERSATA']}',
                        '{$data['QTA_PLUS']}','{$data['COD_UM']}','{$data['COD_MCON']}','{$data['COD_CMOV']}',
                        '{$data['DESC_ART']}','{$data['FL_NEW']}','{$data['DESC_MCON']}','{$createdAt}')
                ";
        try {
            $this->resource->getConnection()->query($sql);
        } catch (\Exception $e) {
            $this->logger->error("[XDOCETES][INSERT] query: {$sql} error: {$e->getMessage()}");
        }
    }

    /**
     * @param $filename
     * @param $canDeleteFile
     */
    protected function manageFtpFile($filename, $canDeleteFile)
    {
        if ($canDeleteFile) {
            $this->logger->info("delete file - {$filename}");
            $this->modifier->delete($filename);
            return;
        }

        $this->logger->info("move file to DONE - {$filename}");
        $this->modifier->moveToDone($filename);
    }
}
