<?php


namespace Drop\Pvs\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;

class InstallSchema implements InstallSchemaInterface
{
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        $connection = $installer->getConnection();

        if ($connection->tableColumnExists('sales_order', 'drop_pvs_exported') === false) {
            $connection->addColumn(
                $setup->getTable('sales_order'),
                'drop_pvs_exported',
                [
                    'type'     => Table::TYPE_BOOLEAN,
                    'length'   => 1,
                    'default'  => 0,
                    'nullable' => true,
                    'comment'  => 'Check if order is exported to Pvs'
                ]
            );
        }
        if ($connection->tableColumnExists('sales_order', 'drop_pvs_delivery_date') === false) {
            $connection->addColumn(
                $setup->getTable('sales_order'),
                'drop_pvs_delivery_date',
                [
                    'type'     => Table::TYPE_DATE,
                    'length'   => 0,
                    'nullable' => true,
                    'comment'  => 'Order delivery date from Pvs'
                ]
            );
        }
        if ($connection->tableColumnExists('magento_rma', 'drop_pvs_exported') === false) {
            $connection->addColumn(
                $setup->getTable('magento_rma'),
                'drop_pvs_exported',
                [
                    'type'     => Table::TYPE_DATE,
                    'length'   => 0,
                    'nullable' => true,
                    'comment'  => 'Check if rma is exported to Pvs'
                ]
            );
        }

        $installer->endSetup();
    }
}
