<?php


namespace Drop\Pvs\Cron\Import;


use Drop\Pvs\Api\FileInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Model\Consumer\Import\Xdocetes as Consumer;
use Drop\Pvs\Model\Ftp\Downloader;
use Drop\Pvs\Model\Publisher;
use Magento\Framework\MessageQueue\PublisherInterface;

class Xdocetes
{

    const TOPIC_NAME = 'pvs.import.xdocetes';

    private $publisher;
    private $consumer;
    private $configuration;
    private $downloader;
    private $fileImport;

    /**
     * Xdocetes constructor.
     * @param Publisher $publisher
     * @param Consumer $consumer
     * @param ConfigurationHelper $configuration
     * @param Downloader $downloader
     * @param FileInterface $fileImport
     */
    public function __construct(
        Publisher $publisher,
        Consumer $consumer,
        ConfigurationHelper $configuration,
        Downloader $downloader,
        FileInterface $fileImport
    )
    {
        $this->publisher = $publisher;
        $this->consumer = $consumer;
        $this->configuration = $configuration;
        $this->downloader = $downloader;
        $this->fileImport = $fileImport;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled()) {
            return;
        }

        $files = $this->downloader->list(
            $this->configuration->getRmaResponseFilename(),
            $this->configuration->getFtpReadDir()
        );
        if (!count($files)) {
            return;
        }

        $publisherData = $this->getPublisherData($files);

        if (!$this->configuration->isJobEnabled()) {
            $this->consumer->process($publisherData);
            return;
        }

        $this->publisher->publish(self::TOPIC_NAME, $publisherData, "Import Xdocetes");
    }

    /**
     * @param $files
     * @param bool $canDeleteFiles
     * @return FileInterface
     */
    public function getPublisherData($files, bool $canDeleteFiles = true): FileInterface
    {
        $this->fileImport->setFiles($files);
        $this->fileImport->setCanDeleteFiles($canDeleteFiles);

        return $this->fileImport;
    }
}
