<?php


namespace Drop\Pvs\Cron\Export;

use Drop\Pvs\Api\Export\RmaInterface;
use Drop\Pvs\Helper\ConfigurationHelper;
use Drop\Pvs\Logger\Logger;
use Drop\Pvs\Model\Publisher;
use Magento\Authorization\Model\UserContextInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Bulk\BulkManagementInterface;
use Magento\Framework\Bulk\OperationInterface;
use Magento\Framework\DataObject\IdentityGeneratorInterface;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Rma\Api\RmaRepositoryInterface;
use Magento\Framework\MessageQueue\PublisherInterface;
use Magento\AsynchronousOperations\Api\Data\OperationInterfaceFactory;
use \Drop\Pvs\Model\Consumer\Export\Rma as Consumer;
use Magento\Rma\Model\Rma\Source\Status;

class Rma
{
    const TOPIC_NAME = 'pvs.export.rma';

    private $publisher;
    private $consumer;
    private $searchCriteriaBuilder;
    private $configuration;
    private $rmaRepository;
    private $rmaInterface;

    /**
     * Rma constructor.
     * @param Publisher $publisher
     * @param Consumer $consumer
     * @param ConfigurationHelper $configurationHelper
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param RmaRepositoryInterface $rmaRepository
     * @param RmaInterface $rmaInterface
     */
    public function __construct(
        Publisher $publisher,
        Consumer $consumer,
        ConfigurationHelper $configurationHelper,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        RmaRepositoryInterface $rmaRepository,
        RmaInterface $rmaInterface
    )
    {
        $this->publisher = $publisher;
        $this->consumer = $consumer;
        $this->configuration = $configurationHelper;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->rmaRepository = $rmaRepository;
        $this->rmaInterface = $rmaInterface;
    }

    public function execute()
    {
        if (!$this->configuration->isEnabled() || !$this->configuration->isCommunicationEnabled()) {
            return;
        }

        // recupero tutti i resi non esportati
        $this->searchCriteriaBuilder->addFilter("drop_pvs_exported", 0);
        if (!$this->configuration->isReturnAutomaticAuthorization()) {
            $this->searchCriteriaBuilder->addFilter("status", Status::STATE_AUTHORIZED);
        }
        if (!$rmas = $this->rmaRepository->getList($this->searchCriteriaBuilder->create())->getItems()) {
            return;
        }

        foreach ($rmas as $rma) {
            $publisherData = $this->getPublisherData($rma);

            if (!$this->configuration->isJobEnabled()) {
                $this->consumer->process($publisherData);
                continue;
            }

            $this->publisher->publish(self::TOPIC_NAME, $publisherData, "Export Rma {$rma->getEntityId()}");
        }
    }

    /**
     * @param $rma
     * @param bool $saveLocal
     * @param bool $saveToFtp
     * @param bool $forced
     * @return RmaInterface
     */
    public function getPublisherData($rma, bool $saveLocal = false, bool $saveToFtp = true, bool $forced = false): RmaInterface
    {
        $this->rmaInterface->setRmaId($rma->getEntityId());
        $this->rmaInterface->setSaveLocal($saveLocal);
        $this->rmaInterface->setSaveToFtp($saveToFtp);
        $this->rmaInterface->setIsForced($forced);

        return $this->rmaInterface;
    }
}
